/*
 * Decompiled with CFR 0.152.
 */
package de.fabb111.joinme.api;

import com.google.common.collect.Multimap;
import de.fabb111.joinme.api.JoinMeMessage;
import de.fabb111.joinme.image.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class JoinMeAPI {
    public static void sendJoinMe(@NonNull JoinMeMessage message, ClickEvent clickAction) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (!message.getMessages().isEmpty()) {
            List<TextComponent> components;
            BaseComponent[] headerComponent = TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message.getSeperatorHeader()));
            BaseComponent[] footerComponent = TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message.getSeperatorFooter()));
            if (message.getHead() == null) {
                Stream<String> messageStream = message.getMessages().stream();
                if (message.isShowPrefix() && message.getPrefix() != null) {
                    messageStream.map(s -> message.getPrefix() + " " + s);
                }
                components = JoinMeAPI.translateColorCodes(messageStream).map(TextComponent::fromLegacyText).map(TextComponent::new).collect(Collectors.toList());
            } else {
                components = JoinMeAPI.translateColorCodes(Arrays.stream(Image.appendTextToImg(Image.toImgMessage(Image.toChatColorArray(message.getHead(), message.getGridSize()), message.getHeadChar()), message.getMessages()))).map(TextComponent::fromLegacyText).map(TextComponent::new).collect(Collectors.toList());
            }
            components.forEach(c -> {
                if (message.isShowHoverMessage()) {
                    c.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message.getHoverMessage()))));
                }
                if (clickAction != null) {
                    c.setClickEvent(clickAction);
                }
            });
            message.getPlayers().forEach(p -> {
                if (message.isShowSeperator()) {
                    p.sendMessage(headerComponent);
                }
                components.forEach(arg_0 -> ((ProxiedPlayer)p).sendMessage(arg_0));
                if (message.isShowSeperator()) {
                    p.sendMessage(footerComponent);
                }
            });
        }
    }

    public static List<String> replaceVariables(ProxiedPlayer p, List<String> messages, Multimap<String, String> categories) {
        return JoinMeAPI.replaceVariables(p, messages, p.getDisplayName(), JoinMeAPI.getCategory(p, categories));
    }

    public static List<String> replaceVariables(ProxiedPlayer p, List<String> messages, String displayName, Multimap<String, String> categories) {
        return JoinMeAPI.replaceVariables(p, messages, displayName, JoinMeAPI.getCategory(p, categories));
    }

    public static List<String> replaceVariables(ProxiedPlayer p, List<String> messages, String category) {
        return JoinMeAPI.replaceVariables(p, messages, p.getDisplayName(), category);
    }

    public static List<String> replaceVariables(ProxiedPlayer p, List<String> messages, String displayName, String category) {
        ArrayList<String> replacedMessages = new ArrayList<String>();
        messages.forEach(msg -> replacedMessages.add(JoinMeAPI.replaceVariables(p, msg, displayName, category)));
        return replacedMessages;
    }

    public static String replaceVariables(ProxiedPlayer p, String message, String displayName, Multimap<String, String> categories) {
        return JoinMeAPI.replaceVariables(p, message, displayName, JoinMeAPI.getCategory(p, categories));
    }

    public static String replaceVariables(ProxiedPlayer p, String message, Multimap<String, String> categories) {
        return JoinMeAPI.replaceVariables(p, message, p.getDisplayName(), categories);
    }

    public static String replaceVariables(ProxiedPlayer p, String message, String category) {
        return JoinMeAPI.replaceVariables(p, message, p.getDisplayName(), category);
    }

    public static String replaceVariables(ProxiedPlayer p, String message, String displayName, String category) {
        return message.replace("%displayName%", displayName).replace("%category%", category == null ? "unknown" : category).replace("%server%", p.getServer().getInfo().getName());
    }

    public static String getCategory(ProxiedPlayer p, Multimap<String, String> categories) {
        String serverName = p.getServer().getInfo().getName();
        String category = null;
        Iterator i = categories.entries().iterator();
        while (i.hasNext() && category == null) {
            Map.Entry e = (Map.Entry)i.next();
            if (!serverName.matches((String)e.getValue())) continue;
            category = (String)e.getKey();
        }
        return category;
    }

    private static Stream<String> translateColorCodes(Stream<String> stream) {
        return stream.map(text -> ChatColor.translateAlternateColorCodes((char)'&', (String)text));
    }
}

