/*
 * Decompiled with CFR 0.152.
 */
package de.fabb111.joinme;

import de.fabb111.joinme.commands.JoinMeCommand;
import de.fabb111.joinme.config.JoinMeConfig;
import de.fabb111.joinme.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class Main
extends Plugin {
    private final Logger log = new Logger(this);
    private File settings_file;
    private JoinMeConfig settings;
    private JoinMeCommand command;

    public void onLoad() {
        this.settings_file = new File(this.getDataFolder(), "settings.yml");
        this.log.info("Creating default config...");
        try {
            this.createDefaultConfig();
        }
        catch (IOException ex) {
            this.log.error("Could not create default config!");
        }
        this.log.info("Loading config...");
        try {
            this.settings = new JoinMeConfig(this.settings_file);
        }
        catch (IOException ex) {
            this.log.error("Could not load config!");
        }
    }

    public void onEnable() {
        if (this.settings != null) {
            this.registerJoinMeCommand();
        }
    }

    public boolean reloadConfig() {
        try {
            this.settings.reloadConfig();
            if (this.command != null) {
                this.log.info("Unregistering command " + this.command.getName() + " (" + this.command.getAliases().length + " aliases)...");
                this.getProxy().getPluginManager().unregisterCommand((Command)this.command);
            }
            this.registerJoinMeCommand();
            return true;
        }
        catch (IOException e) {
            this.log.error("Could not reload config: " + e.getMessage());
            if (!this.settings_file.exists()) {
                this.log.info("Recreating default config...");
                try {
                    this.createDefaultConfig();
                    this.log.info("Loading recreated config...");
                    this.reloadConfig();
                }
                catch (IOException ex) {
                    this.log.error("Could not recreate default config!");
                }
            }
            return false;
        }
    }

    private void registerJoinMeCommand() {
        String commandName = this.settings.getConfig().getString("Command.Name", "joinme");
        List commandAliases = this.settings.getConfig().getStringList("Command.Aliases");
        this.log.info("Registering command " + commandName + " (" + commandAliases.size() + " aliases)...");
        this.command = new JoinMeCommand(this, commandName, commandAliases.toArray(new String[0]));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)this.command);
    }

    private void createDefaultConfig() throws IOException {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!this.settings_file.exists()) {
            Files.copy(this.getResourceAsStream(this.settings_file.getName()), this.settings_file.toPath(), new CopyOption[0]);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public JoinMeConfig getSettings() {
        return this.settings;
    }

    public JoinMeCommand getCommand() {
        return this.command;
    }
}

