/*
 * Decompiled with CFR 0.152.
 */
package net.pipaul.commands;

import net.pipaul.GroupsManager;
import net.pipaul.SaveAndLoad;
import net.pipaul.iGroups;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupList
implements CommandExecutor {
    private iGroups main;

    public GroupList(iGroups main) {
        this.main = main;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command !");
            return true;
        }
        GroupsManager gm = new GroupsManager(this.main);
        Player p = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("group")) {
            if (!(p.hasPermission("igroups.list") || p.hasPermission("igroups.help") || p.hasPermission("igroups.reload"))) {
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7cYou do not have the permission.");
                return true;
            }
            if (args.length == 0) {
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7a/group list\u00a77 : Show the groups list");
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7a/group help\u00a77 : Show the help");
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7a/group reload\u00a77 : Reload the plugin");
                return true;
            }
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("list")) {
                    if (!p.hasPermission("igroups.list")) {
                        p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7cYou do not have the permission.");
                        return true;
                    }
                    p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a77Group list : \u00a7c" + String.join((CharSequence)"\u00a77,\u00a7c ", gm.getGroupListName()));
                    return true;
                }
                if (args[0].equalsIgnoreCase("help")) {
                    if (!p.hasPermission("igroups.help")) {
                        p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7cYou do not have the permission.");
                        return true;
                    }
                    this.sendHelp(p);
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!p.hasPermission("igroups.reload")) {
                        p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7cYou do not have the permission.");
                        return true;
                    }
                    SaveAndLoad sl = new SaveAndLoad(this.main);
                    p.sendMessage(String.valueOf(this.main.getPrefix()) + "Starting reload...");
                    sl.save();
                    this.main.getGroups().clear();
                    this.main.getPerms().clear();
                    sl.load();
                    p.sendMessage(String.valueOf(this.main.getPrefix()) + "Reload complete.");
                    return true;
                }
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7a/group list\u00a77 : Show the groups list");
                p.sendMessage(String.valueOf(this.main.getPrefix()) + "\u00a7a/group help\u00a77 : Show the help");
                return true;
            }
        }
        return false;
    }

    private void sendHelp(Player p) {
        p.sendMessage("\u00a77----------- \u00a72iGroups \u00a77- \u00a76Aide \u00a77------------");
        p.sendMessage("\u00a72/groups \u00a76list\u00a77 : Show the groups list");
        p.sendMessage("\u00a72/groups \u00a76help\u00a77 : Show the help");
        p.sendMessage("\u00a72/setgroup \u00a7c<player> <group>\u00a77 : Promote a player to a group");
        p.sendMessage("\u00a72/addgroup \u00a7c<name>\u00a77 : Add a group");
        p.sendMessage("\u00a72/addperm \u00a7c<permission> <group>\u00a77 : Add a permission to a group");
        p.sendMessage("\u00a72/addinherit \u00a7c<inherit> <group>\u00a77 : Add an inheritance to a group");
        p.sendMessage("\u00a72/setprefix \u00a7c<prefix> <group>\u00a77 : Add a prefix to a group");
        p.sendMessage("\u00a72/setsuffix \u00a7c<suffix> <group>\u00a77 : Add a suffix to a group");
        p.sendMessage("\u00a77------------------------------------");
    }
}

