/*
 * Decompiled with CFR 0.152.
 */
package net.pipaul;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.pipaul.Group;
import net.pipaul.GroupsManager;
import net.pipaul.iGroups;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SaveAndLoad {
    private iGroups main;
    private FileConfiguration config;
    private FileConfiguration configUsers;

    public SaveAndLoad(iGroups main) {
        this.main = main;
        main.setConfigGroups((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder(), "config.yml")));
        main.setConfigUsers((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder(), "users.yml")));
    }

    public void load() {
        GroupsManager gm = new GroupsManager(this.main);
        this.config = this.main.getConfigGroups();
        this.configUsers = this.main.getConfigUsers();
        if (this.config.getConfigurationSection("groups") == null) {
            return;
        }
        Iterator iterator = this.config.getConfigurationSection("groups").getKeys(false).iterator();
        while (iterator.hasNext()) {
            String group;
            String name = group = (String)iterator.next();
            String prefix = this.config.getString("groups." + group + ".prefix");
            String suffix = this.config.getString("groups." + group + ".suffix");
            boolean isDefault = this.config.getBoolean("groups." + group + ".default");
            List perms = this.config.getStringList("groups." + group + ".permissions");
            List inherit = this.config.getStringList("groups." + group + ".inheritance");
            Group g = new Group(name, isDefault);
            g.setPrefix(prefix);
            g.setSuffix(suffix);
            g.setPerms(perms);
            g.setInherit(inherit);
            g.add(this.main);
        }
        if (this.configUsers.getConfigurationSection("users") == null) {
            return;
        }
        for (String s : this.configUsers.getConfigurationSection("users").getKeys(false)) {
            UUID player = UUID.fromString(s);
            String group = this.configUsers.getString("users." + s + ".group");
            Group gU = gm.getGroupByName(group);
            List perms = this.configUsers.getStringList("users." + s + ".perms");
            this.main.getGroups().get(gU).add(player);
            this.main.getPerms().put(player, perms);
        }
    }

    public void save() {
        if (this.main.getGroups().isEmpty()) {
            return;
        }
        this.config = this.main.getConfigGroups();
        this.configUsers = this.main.getConfigUsers();
        for (Map.Entry<Group, List<UUID>> g : this.main.getGroups().entrySet()) {
            this.config.set("groups." + g.getKey().getName() + ".default", (Object)g.getKey().isDefault());
            this.config.set("groups." + g.getKey().getName() + ".prefix", (Object)g.getKey().getPrefix());
            this.config.set("groups." + g.getKey().getName() + ".suffix", (Object)g.getKey().getSuffix());
            for (String perm : this.config.getStringList("groups." + g.getKey().getName() + ".permissions")) {
                if (g.getKey().getPerms().contains(perm)) continue;
                g.getKey().getPerms().add(perm);
            }
            this.config.set("groups." + g.getKey().getName() + ".permissions", g.getKey().getPerms());
            for (String inherit : this.config.getStringList("groups." + g.getKey().getName() + ".inheritance")) {
                if (g.getKey().getInherit().contains(inherit)) continue;
                g.getKey().getInherit().add(inherit);
            }
            this.config.set("groups." + g.getKey().getName() + ".inheritance", g.getKey().getInherit());
            try {
                this.config.save(new File(this.main.getDataFolder(), "config.yml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (UUID uuid : g.getValue()) {
                this.configUsers.set("users." + uuid + ".group", (Object)g.getKey().getName());
                this.configUsers.set("users." + uuid + ".perms", this.main.getPerms().get(uuid));
                try {
                    this.configUsers.save(new File(this.main.getDataFolder(), "users.yml"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

