/*
 * Decompiled with CFR 0.152.
 */
package net.pipaul;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.pipaul.Group;
import net.pipaul.iGroups;
import org.bukkit.OfflinePlayer;

public class GroupsManager {
    private iGroups main;

    public GroupsManager(iGroups main) {
        this.main = main;
    }

    public Group getGroup(OfflinePlayer p) {
        for (Map.Entry<Group, List<UUID>> groups : this.main.getGroups().entrySet()) {
            if (!groups.getValue().contains(p.getUniqueId())) continue;
            return groups.getKey();
        }
        return this.getDefaultGroup();
    }

    public Group getDefaultGroup() {
        for (Group groups : this.main.getGroups().keySet()) {
            if (!groups.isDefault()) continue;
            return groups;
        }
        return null;
    }

    public boolean hasGroup(OfflinePlayer p) {
        for (Map.Entry<Group, List<UUID>> groups : this.main.getGroups().entrySet()) {
            if (!groups.getValue().contains(p.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public void setGroup(OfflinePlayer p, Group g) {
        if (this.hasGroup(p)) {
            this.main.getGroups().get(this.getGroup(p)).remove(p.getUniqueId());
        }
        this.main.getGroups().get(g).add(p.getUniqueId());
    }

    public List<String> getGroupListName() {
        ArrayList<String> groups = new ArrayList<String>();
        for (Group group : this.main.getGroups().keySet()) {
            groups.add(group.getName());
        }
        return groups;
    }

    public Group getGroupByName(String s) {
        for (Group g : this.main.getGroups().keySet()) {
            if (!g.getName().equals(s)) continue;
            return g;
        }
        return null;
    }
}

