/*
 * Decompiled with CFR 0.152.
 */
package de.avankziar.risingstatedev.main;

import de.avankziar.risingstatedev.main.CMDEstate;
import de.avankziar.risingstatedev.main.CMDRisingState;
import de.avankziar.risingstatedev.main.CMDState;
import de.avankziar.risingstatedev.main.EVENTJoinTimestamp;
import de.avankziar.risingstatedev.main.EVENTListener;
import de.avankziar.risingstatedev.main.EVENTTaxAndRent;
import de.avankziar.risingstatedev.main.LocationUtils;
import java.io.File;
import java.io.IOException;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main main;
    private static Permission perms;
    private static Chat chat;
    private static Economy econ;
    private LocationUtils locationUtils;
    private File lDe = null;
    private File lEn = null;
    private File lFr = null;
    private File lDu = null;
    private YamlConfiguration langDe = new YamlConfiguration();
    private YamlConfiguration langEn = new YamlConfiguration();
    private YamlConfiguration langFr = new YamlConfiguration();
    private YamlConfiguration langDu = new YamlConfiguration();
    private File c = null;
    private YamlConfiguration cfg = new YamlConfiguration();
    private File state = null;
    private YamlConfiguration sta = new YamlConfiguration();
    private File players = null;
    private YamlConfiguration ply = new YamlConfiguration();

    static {
        perms = null;
        chat = null;
        econ = null;
    }

    public void onEnable() {
        main = this;
        this.c = new File(main.getDataFolder(), "config.yml");
        this.lDe = new File(main.getDataFolder(), "German.yml");
        this.lEn = new File(main.getDataFolder(), "English.yml");
        this.state = new File(main.getDataFolder(), "state.yml");
        this.players = new File(main.getDataFolder(), "players.yml");
        this.lFr = new File(main.getDataFolder(), "French.yml");
        this.lDu = new File(main.getDataFolder(), "Dutch.yml");
        this.mkdir();
        this.loadYamls();
        super.getCommand("state").setExecutor((CommandExecutor)new CMDState());
        super.getCommand("estate").setExecutor((CommandExecutor)new CMDEstate());
        super.getCommand("risingstate").setExecutor((CommandExecutor)new CMDRisingState());
        super.getServer().getPluginManager().registerEvents((Listener)new EVENTJoinTimestamp(), (Plugin)this);
        super.getServer().getPluginManager().registerEvents((Listener)new EVENTListener(), (Plugin)this);
        super.getServer().getPluginManager().registerEvents((Listener)new EVENTTaxAndRent(), (Plugin)this);
        super.getServer().getPluginManager().registerEvents((Listener)new CMDEstate(), (Plugin)this);
        this.setupPermissions();
        this.setupChat();
        this.setupEconomy();
        this.getServer().getConsoleSender().sendMessage(ChatColor.GOLD + "Rising State" + ChatColor.WHITE + " is " + ChatColor.DARK_GREEN + "running" + ChatColor.WHITE + "!");
        this.getServer().getConsoleSender().sendMessage(ChatColor.GOLD + "Rising State" + ChatColor.WHITE + " is " + ChatColor.DARK_GREEN + "development " + ChatColor.WHITE + "by " + ChatColor.GOLD + "Avankziar" + ChatColor.WHITE + "!");
    }

    public void onDisable() {
        this.saveCon();
        this.saveLangDe();
        this.saveLangEn();
        this.saveLangFr();
        this.saveLangDu();
        this.savePlayers();
        this.saveState();
    }

    private boolean setupChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        chat = (Chat)rsp.getProvider();
        return chat != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private void mkdir() {
        if (!this.lDe.exists()) {
            this.saveResource("German.yml", false);
        }
        if (!this.lEn.exists()) {
            this.saveResource("English.yml", false);
        }
        if (!this.c.exists()) {
            this.saveResource("config.yml", false);
        }
        if (!this.state.exists()) {
            this.saveResource("state.yml", false);
        }
        if (!this.players.exists()) {
            this.saveResource("players.yml", false);
        }
        if (!this.lFr.exists()) {
            this.saveResource("French.yml", false);
        }
        if (!this.lDu.exists()) {
            this.saveResource("Dutch.yml", false);
        }
    }

    public void saveLangDe() {
        try {
            this.langDe.save(this.lDe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLangEn() {
        try {
            this.langEn.save(this.lEn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLangFr() {
        try {
            this.langFr.save(this.lFr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLangDu() {
        try {
            this.langDu.save(this.lDu);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveCon() {
        try {
            this.cfg.save(this.c);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveState() {
        try {
            this.sta.save(this.state);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePlayers() {
        try {
            this.ply.save(this.players);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadYamls() {
        try {
            this.cfg.load(this.c);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.langDe.load(this.lDe);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.langEn.load(this.lEn);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.sta.load(this.state);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.ply.load(this.players);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.langFr.load(this.lFr);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            this.langDu.load(this.lDu);
        }
        catch (IOException | InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    public static Main getInstance() {
        return main;
    }

    public LocationUtils getLocationUtils() {
        return this.locationUtils;
    }

    public YamlConfiguration Language() {
        if (this.cfg.getString("RS.language").equalsIgnoreCase("german")) {
            return this.langDe;
        }
        if (this.cfg.getString("RS.language").equalsIgnoreCase("english")) {
            return this.langEn;
        }
        if (this.cfg.getString("RS.language").equalsIgnoreCase("french")) {
            return this.langFr;
        }
        if (this.cfg.getString("RS.language").equalsIgnoreCase("dutch")) {
            return this.langDu;
        }
        return this.cfg;
    }

    public String LanguageString() {
        return this.cfg.getString("RS.language");
    }

    public static Main getPlugin() {
        return main;
    }

    public YamlConfiguration getConY() {
        return this.cfg;
    }

    public YamlConfiguration getStaY() {
        return this.sta;
    }

    public YamlConfiguration getPlaY() {
        return this.ply;
    }

    public File getConF() {
        return this.c;
    }

    public File getStaF() {
        return this.state;
    }

    public File getPlaF() {
        return this.players;
    }

    public static Economy getEcononomy() {
        return econ;
    }

    public static Permission getPermissions() {
        return perms;
    }

    public static Chat getChat() {
        return chat;
    }
}

