/*
 * Decompiled with CFR 0.152.
 */
package me.dragon0617.api;

import java.util.Arrays;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ItemAPI {
    private static ItemAPI itemAPI;

    public ItemAPI(ItemAPI itemAPI) {
        ItemAPI.itemAPI = itemAPI;
    }

    public static ItemAPI getItemAPI() {
        return itemAPI;
    }

    public ItemStack makeItem(Material material) {
        ItemStack itemStack = new ItemStack(material);
        return itemStack;
    }

    public ItemStack addNamedItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack addEnchantment(Material mat, Enchantment enchantment, int level, String name) {
        ItemStack item = new ItemStack(mat);
        item.addEnchantment(enchantment, level);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack multipleEnchants(Material mat, Enchantment enchantment1, int lvl1, Enchantment enchantment2, int lvl2, String name) {
        ItemStack item = new ItemStack(mat);
        item.addEnchantment(enchantment1, lvl1);
        item.addEnchantment(enchantment2, lvl2);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(name);
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemStack addLore(Material mat, String name, String l) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(l));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack addMultipleLores(Material m, String name, String l1, String l2, String l3) {
        ItemStack itemStack = new ItemStack(m);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(l1, l2, l3));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack itemAmount(Material m, int amount) {
        ItemStack itemStack = new ItemStack(m, amount);
        return itemStack;
    }

    public ItemStack addIDItem(Material mat, int amount, byte itemID, String name) {
        ItemStack itemStack = new ItemStack(mat, amount, (short)itemID);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(name);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack customItem(Material m, Enchantment e1, int lvl1, Enchantment e2, int lvl2, String name, String l1, String l2, String l3) {
        ItemStack itemStack = new ItemStack(m);
        itemStack.addUnsafeEnchantment(e1, lvl1);
        itemStack.addUnsafeEnchantment(e2, lvl2);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(l1, l2, l3));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack makeNormalPotion(int amount, byte potID) {
        ItemStack item = new ItemStack(Material.POTION, amount, (short)potID);
        return item;
    }

    public ItemStack makeSplashPotion(int amount, short potID) {
        ItemStack item = new ItemStack(Material.POTION, amount, potID);
        return item;
    }

    public ItemStack coloredArmor(Material material, Color c, String name) {
        ItemStack itemStack = new ItemStack(material);
        LeatherArmorMeta armorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
        armorMeta.setColor(c);
        armorMeta.setDisplayName(name);
        itemStack.setItemMeta((ItemMeta)armorMeta);
        return itemStack;
    }
}

