/*
 * Decompiled with CFR 0.152.
 */
package com.SimplyBallistic.ForceRules.listeners;

import com.SimplyBallistic.ForceRules.FRPlugin;
import com.SimplyBallistic.ForceRules.PlayerList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;

public class JoinListener
implements Listener {
    @EventHandler
    public void playerJoin(PlayerLoginEvent e) {
        if (!PlayerList.containsPlayer(e.getPlayer().getUniqueId())) {
            Bukkit.getScheduler().runTaskLater((Plugin)FRPlugin.getInstance(), () -> JoinListener.printRules((CommandSender)e.getPlayer(), false), 80L);
        }
    }

    public static void printRules(CommandSender sender, boolean raw) {
        FRPlugin.toColor(FRPlugin.getInstance().getConfig().getStringList("Rules")).forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
        if (raw) {
            return;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!PlayerList.containsPlayer(p.getUniqueId())) {
                p.sendMessage(ChatColor.GREEN + "Type '/rules accept' to accept the rules");
                p.sendMessage(ChatColor.RED + "Or '/rules deny' to deny the rules");
            } else {
                p.sendMessage(ChatColor.GREEN + "You already accepted the rules!");
                p.sendMessage(ChatColor.RED + "You may deny them again if you wish with '/rules deny'");
            }
        }
    }

    public static void timestampPlayer(UUID id, TimestampType ts) {
        String type = ts.toString().toLowerCase();
        PlayerList.getPlayerData().set("players." + id.toString() + "." + type + ".date", (Object)new SimpleDateFormat("dd/MM/yy").format(Calendar.getInstance().getTime()));
        PlayerList.getPlayerData().set("players." + id.toString() + "." + type + ".time", (Object)new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime()));
        try {
            PlayerList.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum TimestampType {
        FIRST_LOGIN,
        ACCEPTANCE;

    }
}

