/*
 * Decompiled with CFR 0.152.
 */
package com.SimplyBallistic.ForceRules;

import com.SimplyBallistic.ForceRules.PlayerList;
import com.SimplyBallistic.ForceRules.commands.Command_Forcerule;
import com.SimplyBallistic.ForceRules.commands.Command_Rules;
import com.SimplyBallistic.ForceRules.listeners.AntiChatListener;
import com.SimplyBallistic.ForceRules.listeners.AntiMoveListener;
import com.SimplyBallistic.ForceRules.listeners.JoinListener;
import com.SimplyBallistic.ForceRules.util.SpigetUpdater.Bukkit.src.main.java.org.inventivetalent.update.spiget.SpigetUpdate;
import com.SimplyBallistic.ForceRules.util.SpigetUpdater.Core.src.main.java.org.inventivetalent.update.spiget.UpdateCallback;
import com.SimplyBallistic.ForceRules.util.SpigetUpdater.Core.src.main.java.org.inventivetalent.update.spiget.comparator.VersionComparator;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FRPlugin
extends JavaPlugin {
    private static FRPlugin instance;
    private Command_Forcerule frule = new Command_Forcerule();
    private Command_Rules rules = new Command_Rules();
    private SpigetUpdate updater;
    UpdateCallback callback = new UpdateCallback(){

        @Override
        public void updateAvailable(String newVersion, String downloadUrl, boolean canAutoDownload) {
            if (canAutoDownload) {
                if (FRPlugin.this.updater.downloadUpdate()) {
                    FRPlugin.this.getLogger().info("New update has been downloaded! Updated from " + FRPlugin.this.getDescription().getVersion() + " to " + newVersion + "!");
                } else {
                    FRPlugin.this.getLogger().warning("Update failed! Manually download here: " + downloadUrl);
                }
            }
        }

        @Override
        public void upToDate() {
            FRPlugin.this.getLogger().info("This version is upto date!");
        }
    };

    public void onEnable() {
        instance = this;
        this.updater = new SpigetUpdate((Plugin)FRPlugin.getInstance(), 36038);
        this.updater.setVersionComparator(VersionComparator.SEM_VER);
        new PlayerList();
        this.updater.checkForUpdate(this.callback);
        this.saveDefaultConfig();
        this.getLogger().info("Initiated! Current rule layout: ");
        FRPlugin.toColor(this.getConfig().getStringList("Rules")).forEach(arg_0 -> ((ConsoleCommandSender)Bukkit.getConsoleSender()).sendMessage(arg_0));
        this.getLogger().info("If any errors are present relating to config, make sure to check your syntax in the config, or just delete it and run /fr reload");
        this.getServer().getPluginCommand("rules").setExecutor((CommandExecutor)this.rules);
        this.getServer().getPluginCommand("rules").setTabCompleter((TabCompleter)this.rules);
        this.getServer().getPluginCommand("forcerules").setExecutor((CommandExecutor)this.frule);
        this.getServer().getPluginCommand("forcerules").setTabCompleter((TabCompleter)this.frule);
        this.registerListeners();
    }

    public static List<String> toColor(List<String> edit) {
        ArrayList<String> ret = new ArrayList<String>();
        edit.forEach(s -> {
            boolean bl = ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        });
        return ret;
    }

    public void onDisable() {
        this.reloadConfig();
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new AntiMoveListener(), (Plugin)this);
        pm.registerEvents((Listener)new AntiChatListener(), (Plugin)this);
        pm.registerEvents((Listener)new JoinListener(), (Plugin)this);
    }

    public static FRPlugin getInstance() {
        return instance;
    }
}

