/*
 * Decompiled with CFR 0.152.
 */
package me.mehboss.necessities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.mehboss.necessities.PlaceHolder;
import me.mehboss.necessities.Weight;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Bathroom
extends JavaPlugin
implements Listener {
    public ArrayList<String> waitingforBathroom = new ArrayList();
    File customYml = new File(this.getDataFolder() + "/players.yml");
    FileConfiguration customConfig = YamlConfiguration.loadConfiguration((File)this.customYml);

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Weight(this), (Plugin)this);
        this.getCommand("weight").setExecutor((CommandExecutor)new Weight(this));
        this.registerConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceHolder(this).register();
        }
    }

    public void saveCustomYml(FileConfiguration ymlConfig, File ymlFile) {
        try {
            ymlConfig.save(ymlFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        this.saveCustomYml(this.customConfig, this.customYml);
        this.reloadConfig();
    }

    private void registerConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.getLogger();
    }

    public void message(String message, CommandSender p) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Necessities");
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("Messages.Prefix"));
        if (message.isEmpty()) {
            return;
        }
        if (prefix.isEmpty()) {
            prefix = "";
        }
        p.sendMessage(message.replaceAll("%prefix%", prefix));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (cmd.getName().equalsIgnoreCase("usebathroom")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                String bladder = this.customConfig.getString("Players." + player.getName() + ".Bladder");
                String BathroomUse = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Use-Bathroom"));
                String EmptyBladder = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Bladder-Empty"));
                String CauldronStand = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Not-On-Cauldron"));
                String notenabled = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Not-Enabled"));
                String automaticuse = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Use-Bathroom-Automatic"));
                String block = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Bathroom-Use.Block"));
                Location l = player.getLocation();
                Location d = new Location(l.getWorld(), l.getX(), l.getY() - 1.0, l.getZ());
                if (player.hasPermission("necessities.bathroom")) {
                    if (this.getConfig().getString("Bathroom-Use.Automatic-Use").equals("true")) {
                        this.message(automaticuse, (CommandSender)player);
                        return false;
                    }
                    if (!this.getConfig().getString("Toggle.Bladder-Enabled").equals("true")) {
                        this.message(notenabled, (CommandSender)player);
                        return false;
                    }
                    if (d.getBlock().getType() == Material.matchMaterial((String)block.toUpperCase())) {
                        if (!bladder.equals("0")) {
                            this.message(BathroomUse, (CommandSender)player);
                            this.customConfig.set("Players." + player.getName() + ".Bladder", (Object)"0");
                            this.saveCustomYml(this.customConfig, this.customYml);
                            if (this.getConfig().getString("Bathroom-Use.Player-Effect").equals("true")) {
                                player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 30, 1));
                                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 30, 1));
                            }
                            if (!this.getConfig().getString("Bathroom-Use.Sound").equalsIgnoreCase("none")) {
                                player.playSound(player.getLocation(), Sound.valueOf((String)this.getConfig().getString("Bathroom-Use.Sound").toUpperCase()), 1.0f, 1.0f);
                            }
                        } else {
                            this.message(EmptyBladder, (CommandSender)player);
                        }
                    } else {
                        this.message(CauldronStand, (CommandSender)player);
                    }
                } else {
                    String noPerm = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.No-Perm").replaceAll("%PERMISSION%", "necessities.usebathroom"));
                    this.message(noPerm, (CommandSender)player);
                }
            }
        } else if (cmd.getName().equalsIgnoreCase("bladder")) {
            Player player = (Player)sender;
            String notenabled = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Not-Enabled"));
            String bladderlevel = this.customConfig.getString("Players." + player.getName() + ".Bladder");
            String bladdertotal = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Bladder-Total").replaceAll("%AMOUNT%", bladderlevel));
            if (player.hasPermission("necessities.bladder")) {
                if (!this.getConfig().getString("Toggle.Bladder-Enabled").equals("true")) {
                    this.message(notenabled, (CommandSender)player);
                    return false;
                }
                if (player instanceof Player) {
                    this.message(bladdertotal, (CommandSender)player);
                }
            } else {
                String noPerm = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.No-Perm").replaceAll("%PERMISSION%", "necessities.bladder"));
                this.message(noPerm, (CommandSender)player);
            }
        } else if (cmd.getName().equalsIgnoreCase("necessities")) {
            if (args.length == 0 || !args[0].equalsIgnoreCase("reload")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8&l&m|-------------------------------------------|&r"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"   &c&lNecessities &8(&av2.6&8)"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"     &dAuthor: &cMehBoss"));
                sender.sendMessage(" ");
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"     &a&lCommands:"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"       &8'&c/weight&8' &7- checks your weight."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"       &8'&c/bladder&8' &7- checks your bladder."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"       &8'&c/usebathroom&8' &7- uses the bathroom."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"       &8'&c/necessities&8' &7- shows this help page."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"       &8'&c/necessities reload&8' &7- reloads the plugin."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8&l&m|-------------------------------------------|&r"));
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("necessities.reload")) {
                    this.reloadConfig();
                    this.saveCustomYml(this.customConfig, this.customYml);
                    this.message(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Reload")), sender);
                } else {
                    String noPerm = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.No-Perm").replaceAll("%PERMISSION%", "necessities.reload"));
                    this.message(noPerm, sender);
                }
            }
        }
        return false;
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent e) {
        Player player = e.getPlayer();
        String amountstring = this.getConfig().getString("Potion-Drink.Thirst");
        int amount = this.getConfig().getInt("Potion-Drink.Thirst");
        int current = this.customConfig.getInt("Players." + player.getName() + ".Bladder");
        String FullBladder = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Full-Bladder"));
        String PredictFullBladder = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Predict-Bladder-Increase"));
        String BladderIncrease = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Bladder-Increase").replaceAll("%AMOUNT%", amountstring).toString());
        if (e.getItem().getType() == Material.POTION || e.getItem().getType() == Material.MILK_BUCKET) {
            if (!this.getConfig().getString("Toggle.Bladder-Enabled").equals("true")) {
                return;
            }
            if (this.customConfig.getString("Players." + player.getName() + ".Bladder").equals("100")) {
                e.setCancelled(true);
                this.message(FullBladder, (CommandSender)player);
            } else {
                int predict = current + amount;
                if (predict > 100) {
                    this.message(PredictFullBladder, (CommandSender)player);
                    e.setCancelled(true);
                } else {
                    this.message(BladderIncrease, (CommandSender)player);
                    this.customConfig.set("Players." + player.getName() + ".Bladder", (Object)(current + amount));
                    this.saveCustomYml(this.customConfig, this.customYml);
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        if (this.getConfig().getString("Bathroom-Use.Automatic-Use").equals("true") && this.getConfig().getString("Toggle.Bladder-Enabled").equals("true")) {
            String block = this.getConfig().getString("Bathroom-Use.Block");
            Location l = p.getLocation();
            Location d = new Location(l.getWorld(), l.getX(), l.getY() - 1.0, l.getZ());
            String bladder = this.customConfig.getString("Players." + p.getName() + ".Bladder");
            if (!bladder.equals("0")) {
                if (d.getBlock().getType() != Material.matchMaterial((String)block.toUpperCase()) && this.waitingforBathroom.contains(p.getName())) {
                    this.waitingforBathroom.remove(p.getName());
                    return;
                }
                if (d.getBlock().getType() == Material.matchMaterial((String)block.toUpperCase())) {
                    final String BathroomUse = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Use-Bathroom"));
                    final String sound = this.getConfig().getString("Bathroom-Use.Sound");
                    String timed = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Time").replaceAll("%time%", String.valueOf(this.getConfig().getInt("Bathroom-Use.Automatic-Use-Seconds"))));
                    if (!this.waitingforBathroom.contains(p.getName())) {
                        this.message(timed, (CommandSender)p);
                        this.waitingforBathroom.add(p.getName());
                    }
                    Long timeset = this.getConfig().getLong("Bathroom-Use.Automatic-Use-Seconds") * 20L;
                    new BukkitRunnable(){

                        public void run() {
                            if (Bathroom.this.waitingforBathroom.contains(p.getName())) {
                                Bathroom.this.message(BathroomUse, (CommandSender)p);
                                Bathroom.this.waitingforBathroom.remove(p.getName());
                                Bathroom.this.customConfig.set("Players." + p.getName() + ".Bladder", (Object)"0");
                                Bathroom.this.saveCustomYml(Bathroom.this.customConfig, Bathroom.this.customYml);
                                if (!Bathroom.this.getConfig().getString("Bathroom-Use.Sound").equals("none")) {
                                    p.playSound(p.getLocation(), Sound.valueOf((String)sound.toUpperCase()), 1.0f, 1.0f);
                                }
                            }
                        }
                    }.runTaskLater(Bukkit.getPluginManager().getPlugin("Necessities"), timeset.longValue());
                }
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.customConfig.getString("Players." + player.getName()) == null) {
            this.customConfig.createSection("Players." + player.getName() + ".Bladder");
            this.customConfig.set("Players." + player.getName() + ".Bladder", (Object)"0");
            this.customConfig.createSection("Players." + player.getName() + ".Weight");
            this.customConfig.set("Players." + player.getName() + ".Weight", (Object)"0");
            this.saveCustomYml(this.customConfig, this.customYml);
        }
    }
}

