/*
 * Decompiled with CFR 0.152.
 */
package me.mineridge.list;

import com.earth2me.essentials.IEssentials;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    public static final File root = new File("plugins" + File.separator + "mrStaffList");
    List<Player> vanished = new ArrayList<Player>();
    Chat chat = null;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.setupChat();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("list")) {
            ArrayList<String> staff = new ArrayList<String>();
            int total = 0;
            int donors = 0;
            Player[] playerArray = this.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (!this.vanished.contains(p)) {
                    if (p.hasPermission("list.donor")) {
                        ++donors;
                    }
                    if (p.hasPermission("list.staff")) {
                        if (this.chat == null) {
                            staff.add(p.getName());
                        } else {
                            staff.add(String.valueOf(this.chat.getPlayerPrefix(p)) + p.getName());
                        }
                    }
                    ++total;
                }
                ++n2;
            }
            String staffList = "None";
            int i = 0;
            while (i < staff.size()) {
                if (staffList.startsWith("None")) {
                    staffList = "";
                }
                staffList = String.valueOf(staffList) + (String)staff.get(i) + (i != staff.size() - 1 ? ", " : "");
                ++i;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.header-message")));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.donor-message").replaceAll("%amount%", "" + donors)));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.total-message").replaceAll("%amount%", "" + total)));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.staff-message").replaceAll("%list%", staffList)));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.footer-message")));
            return true;
        }
        return false;
    }

    private boolean setupChat() {
        RegisteredServiceProvider chatProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        return this.chat != null;
    }

    @EventHandler
    public void onPreCommand(PlayerCommandPreprocessEvent e) {
        String command = e.getMessage().split(" ")[0];
        if (command.equalsIgnoreCase("/v") || command.equalsIgnoreCase("vanish")) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    IEssentials ess = (IEssentials)Main.this.getServer().getPluginManager().getPlugin("Essentials");
                    Main.this.vanished.clear();
                    Player[] playerArray = Bukkit.getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player p = playerArray[n2];
                        if (ess.getUser(p).isVanished()) {
                            Main.this.vanished.add(p);
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

