/*
 * Decompiled with CFR 0.152.
 */
package de.romian.hideplayers.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private Material mat;
    private String name;
    private ItemStack is;
    private ItemMeta im;
    private List<String> lore;
    private DyeColor color;

    public ItemBuilder(Material mat) {
        this.mat = mat;
        this.name = "";
        this.is = new ItemStack(mat);
        this.im = this.is.getItemMeta();
        this.lore = new ArrayList<String>();
    }

    public Material getMaterial() {
        return this.mat;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    public ItemBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder enchantment(Enchantment enchantment, int level) {
        this.im.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder enchantment(Enchantment enchantment) {
        this.enchantment(enchantment, 1);
        return this;
    }

    public ItemBuilder lore(String lore) {
        this.lore.add(lore);
        return this;
    }

    public ItemBuilder durability(int dur) {
        this.is.setDurability((short)dur);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.is.setAmount(amount);
        return this;
    }

    public ItemBuilder color(DyeColor color) {
        this.is.setDurability((short)color.getData());
        return this;
    }

    public ItemBuilder unbreakable(boolean b) {
        this.im.spigot().setUnbreakable(b);
        return this;
    }

    public ItemBuilder hideFlag(ItemFlag flag) {
        this.im.addItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemStack build() {
        this.im.setDisplayName(this.name);
        this.im.setLore(this.lore);
        this.is.setItemMeta(this.im);
        return this.is;
    }
}

