/*
 * Decompiled with CFR 0.152.
 */
package de.romian.hideplayers.listener;

import de.romian.hideplayers.utils.ConfigReader;
import de.romian.hideplayers.utils.ItemBuilder;
import de.romian.hideplayers.utils.VisibleManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    static File file = new File("plugins//HidePlayers", "hidingstate.yml");
    public static YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (ConfigReader.getBoolean("GetItemOnJoin") && ConfigReader.getBoolean("SaveHidingState")) {
            PlayerJoinListener.createFile();
            int slot = ConfigReader.getInt("ItemSlot") - 1;
            if (PlayerJoinListener.getHidingState(p) == 1) {
                String material = ConfigReader.getString("HidePlayerItem.Item");
                String lore = ConfigReader.getConfigMessage("HidePlayerItem.Lore");
                String displayname = ConfigReader.getConfigMessage("HidePlayerItem.Displayname");
                Material mat = Material.matchMaterial((String)material);
                p.getInventory().setItem(slot, new ItemBuilder(mat).name(displayname).lore(lore).build());
            } else if (PlayerJoinListener.getHidingState(p) == 2) {
                String material = ConfigReader.getString("ShowPlayerItem.Item");
                String lore = ConfigReader.getConfigMessage("ShowPlayerItem.Lore");
                String displayname = ConfigReader.getConfigMessage("ShowPlayerItem.Displayname");
                Material mat = Material.matchMaterial((String)material);
                p.getInventory().setItem(slot, new ItemBuilder(mat).name(displayname).lore(lore).build());
                VisibleManager.hide(p);
            }
        }
    }

    private static void createFile() {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int getHidingState(Player p) {
        int state;
        if (cfg.isSet(p.getUniqueId().toString())) {
            state = cfg.getInt(p.getUniqueId().toString());
        } else {
            cfg.set(p.getUniqueId().toString(), (Object)1);
            PlayerJoinListener.saveFile();
            state = 1;
        }
        return state;
    }

    public static void saveFile() {
        try {
            cfg.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

