/*
 * Decompiled with CFR 0.152.
 */
package de.romian.hideplayers.listener;

import de.romian.hideplayers.listener.PlayerJoinListener;
import de.romian.hideplayers.utils.ConfigReader;
import de.romian.hideplayers.utils.ItemBuilder;
import de.romian.hideplayers.utils.VisibleManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerInteractListener
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        String hideMaterial = ConfigReader.getString("HidePlayerItem.Item");
        String hideLore = ConfigReader.getConfigMessage("HidePlayerItem.Lore");
        String hideDisplayname = ConfigReader.getConfigMessage("HidePlayerItem.Displayname");
        Material hideMat = Material.matchMaterial((String)hideMaterial);
        String showMaterial = ConfigReader.getString("ShowPlayerItem.Item");
        String showLore = ConfigReader.getConfigMessage("ShowPlayerItem.Lore");
        String showDisplayname = ConfigReader.getConfigMessage("ShowPlayerItem.Displayname");
        Material showMat = Material.matchMaterial((String)showMaterial);
        ItemStack hidePlayer = new ItemBuilder(hideMat).name(hideDisplayname).lore(hideLore).build();
        ItemStack showPlayer = new ItemBuilder(showMat).name(showDisplayname).lore(showLore).build();
        if (p.getItemInHand() != null && (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && p.getItemInHand().hasItemMeta()) {
            if (p.getItemInHand().getType() == hideMat && p.getItemInHand().getItemMeta().getDisplayName().equals(hideDisplayname)) {
                VisibleManager.hide(p);
                PlayerInteractListener.setHidingState(p, 2);
                p.playSound(p.getLocation(), Sound.LEVEL_UP, 5.0f, 5.0f);
                p.setItemInHand(showPlayer);
            } else if (p.getItemInHand().getType() == showMat && p.getItemInHand().getItemMeta().getDisplayName().equals(showDisplayname)) {
                VisibleManager.show(p);
                PlayerInteractListener.setHidingState(p, 1);
                p.playSound(p.getLocation(), Sound.LEVEL_UP, 5.0f, 5.0f);
                p.setItemInHand(hidePlayer);
            }
        }
    }

    private static void setHidingState(Player p, int state) {
        if (ConfigReader.getBoolean("SaveHidingState")) {
            PlayerJoinListener.cfg.set(p.getUniqueId().toString(), (Object)state);
            PlayerJoinListener.saveFile();
        }
    }
}

