/*
 * Decompiled with CFR 0.152.
 */
package com.goaltimellc.plugin.levitate.events.player;

import com.goaltimellc.plugin.levitate.GTLevitatePlugin;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class eventPlayerInteractEvent
implements Listener {
    GTLevitatePlugin plugin;

    public eventPlayerInteractEvent(GTLevitatePlugin passedPlugin) {
        this.plugin = passedPlugin;
        Logger logger = Logger.getLogger("GTLevitate");
        logger.info("eventPlayerInteractEvent :: Constructor");
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        Logger logger = Logger.getLogger("GTLevitate");
        if (!event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player player = event.getPlayer();
        boolean allComponentsAreValid = true;
        String configPressurePlate = this.plugin.getConfig().getString("pressurePlate");
        Material materialPressurePlate = Material.LIGHT_WEIGHTED_PRESSURE_PLATE;
        try {
            materialPressurePlate = Material.getMaterial((String)configPressurePlate);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        String configPlatformBase = this.plugin.getConfig().getString("platformBase");
        Material materialPlatformBase = Material.PURPUR_BLOCK;
        try {
            materialPlatformBase = Material.getMaterial((String)configPlatformBase);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        String configPlatformPower = this.plugin.getConfig().getString("platformPower");
        Material materialPlatformPower = Material.REDSTONE_BLOCK;
        try {
            materialPlatformPower = Material.getMaterial((String)configPlatformPower);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        if (!allComponentsAreValid) {
            logger.info("INVALID CONFIGURATION FOR gtLevitate PLUGIN");
            player.sendMessage("There is a configuration issue with the gtLevitate Plugin. Contact an Admin.");
            return;
        }
        Block blockCheckPlate = event.getClickedBlock();
        if (!blockCheckPlate.getType().equals((Object)materialPressurePlate)) {
            return;
        }
        Block blockCheckBase = blockCheckPlate.getRelative(0, -1, 0);
        if (!blockCheckBase.getType().equals((Object)materialPlatformBase)) {
            return;
        }
        Block blockCheckPower = blockCheckBase.getRelative(0, -1, 0);
        if (!blockCheckPower.getType().equals((Object)materialPlatformPower)) {
            return;
        }
        boolean configRequireElytra = this.plugin.getConfig().getBoolean("requireElytra");
        if (configRequireElytra) {
            ItemStack itemChestplate = player.getInventory().getChestplate();
            if (itemChestplate == null) {
                player.sendMessage("You must be wearing an Elytra to use this Levitation Pad!");
                return;
            }
            if (!itemChestplate.getType().equals((Object)Material.ELYTRA)) {
                player.sendMessage("You must be wearing an Elytra to use this Levitation Pad!");
                return;
            }
        }
        int configLevitationPower = this.plugin.getConfig().getInt("levitationPower");
        int configLevitationDuration = this.plugin.getConfig().getInt("levitationDuration");
        int totalPower = configLevitationPower;
        Block checkMorePower = blockCheckPower.getRelative(0, -1, 0);
        boolean morePowerBlocks = true;
        while (morePowerBlocks) {
            if (checkMorePower.getType().equals((Object)materialPlatformPower)) {
                totalPower += configLevitationPower;
                if (--configLevitationPower < 1) {
                    morePowerBlocks = false;
                }
            } else {
                morePowerBlocks = false;
            }
            checkMorePower = checkMorePower.getRelative(0, -1, 0);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20 * configLevitationDuration, totalPower));
    }
}

