/*
 * Decompiled with CFR 0.152.
 */
package com.goaltimellc.plugin.levitate.commands;

import com.goaltimellc.plugin.levitate.GTLevitatePlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class commandGTLevitateCommandHandler
implements CommandExecutor {
    GTLevitatePlugin plugin;
    List<String> commandsPlayerOnly = new ArrayList<String>();

    public commandGTLevitateCommandHandler(GTLevitatePlugin passedPlugin) {
        this.plugin = passedPlugin;
        this.commandsPlayerOnly.add("gtrecipes");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Logger logger = this.plugin.getLogger();
        if (!(sender instanceof Player)) {
            if (this.commandsPlayerOnly.contains(command.getName().toLowerCase())) {
                sender.sendMessage("You must be a player to run this command.");
                return false;
            }
            player = null;
        } else {
            player = (Player)sender;
        }
        switch (command.getName().toLowerCase()) {
            case "gtlevitate": {
                String configPressurePlate = this.plugin.getConfig().getString("pressurePlate");
                String configPlatformBase = this.plugin.getConfig().getString("platformBase");
                String configPlatformPower = this.plugin.getConfig().getString("platformPower");
                int configLevitationPower = this.plugin.getConfig().getInt("levitationPower");
                int configLevitationDuration = this.plugin.getConfig().getInt("levitationDuration");
                boolean configRequireElytra = this.plugin.getConfig().getBoolean("requireElytra");
                boolean allComponentsAreValid = true;
                Material materialPressurePlate = Material.LIGHT_WEIGHTED_PRESSURE_PLATE;
                try {
                    materialPressurePlate = Material.getMaterial((String)configPressurePlate);
                }
                catch (IllegalArgumentException e) {
                    allComponentsAreValid = false;
                }
                catch (NullPointerException e) {
                    allComponentsAreValid = false;
                }
                Material materialPlatformBase = Material.PURPUR_BLOCK;
                try {
                    materialPlatformBase = Material.getMaterial((String)configPlatformBase);
                }
                catch (IllegalArgumentException e) {
                    allComponentsAreValid = false;
                }
                catch (NullPointerException e) {
                    allComponentsAreValid = false;
                }
                Material materialPlatformPower = Material.REDSTONE_BLOCK;
                try {
                    materialPlatformPower = Material.getMaterial((String)configPlatformPower);
                }
                catch (IllegalArgumentException e) {
                    allComponentsAreValid = false;
                }
                catch (NullPointerException e) {
                    allComponentsAreValid = false;
                }
                if (!allComponentsAreValid) {
                    logger.info("INVALID CONFIGURATION FOR gtLevitate PLUGIN");
                    player.sendMessage("There is a configuration issue with the gtLevitate Plugin. Contact an Admin.");
                    return false;
                }
                String namePressurePlate = materialPressurePlate.toString();
                String namePlatformBase = materialPlatformBase.toString();
                String namePlatformPower = materialPlatformPower.toString();
                player.sendMessage("--------------------------------------------------");
                player.sendMessage("GTLevitate is a plugin that allows you create a platform for initiating levitation:");
                player.sendMessage("   => Place a " + namePressurePlate + " onto a " + namePlatformBase + " that is above a " + namePlatformPower);
                player.sendMessage("   => Stepping onto the pressure plate will initiate (" + configLevitationPower + "x) levitation for " + configLevitationDuration + " seconds");
                if (configRequireElytra) {
                    player.sendMessage("   => BUT, only if you are wearing an Elytra!");
                } else {
                    player.sendMessage("   => Even if you are NOT wearing an Elytra!");
                }
                player.sendMessage("   => You can stack additional " + namePlatformPower + " below the first one, to increase the strength, up to " + configLevitationPower + " blocks");
                if (player.isOp()) {
                    player.sendMessage("Administrative commands are available using /gtlev");
                }
                player.sendMessage("--------------------------------------------------");
                return true;
            }
            case "gtlev": {
                if (!player.isOp()) {
                    player.sendMessage("You must be OP to run this command!");
                    return false;
                }
                Location playerLocation = player.getLocation();
                Block playerBlock = playerLocation.getBlock();
                Block playerBaseBlock = playerBlock.getRelative(0, -1, 0);
                if (args.length > 0) {
                    switch (args[0].toLowerCase()) {
                        case "createpad": {
                            if (args.length >= 4 && args.length <= 4) {
                                playerBaseBlock.getRelative(-1, 0, -1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, 0).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, 1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(0, 0, -1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(0, 0, 0).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(0, 0, 1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(1, 0, -1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(1, 0, 0).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(1, 0, 1).setType(Material.DIAMOND_BLOCK);
                                playerBaseBlock.getRelative(-3, 0, -1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-3, 0, 0).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-3, 0, 1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-2, 0, -2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-2, 0, -1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-2, 0, 0).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-2, 0, 1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-2, 0, 2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, -3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, -2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, 2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(-1, 0, 3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(0, 0, -3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(0, 0, -2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(0, 0, 2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(0, 0, 3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(1, 0, -3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(1, 0, -2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(1, 0, 2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(1, 0, 3).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(2, 0, -2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(2, 0, -1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(2, 0, 0).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(2, 0, 1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(2, 0, 2).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(3, 0, -1).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(3, 0, 0).setType(Material.EMERALD_BLOCK);
                                playerBaseBlock.getRelative(3, 0, 1).setType(Material.EMERALD_BLOCK);
                                return true;
                            }
                            player.sendMessage("Please use format: ");
                            player.sendMessage("  /gtlev createpad <x> <y> <z>");
                            return false;
                        }
                        case "help": {
                            player.sendMessage("--------------------------------------------------");
                            player.sendMessage("Use /gtlevitate for help!");
                            return true;
                        }
                    }
                    player.sendMessage("--------------------------------------------------");
                    player.sendMessage("GTLevitate doesn't understand!");
                    player.sendMessage("  \"That is definitely above our head!\"");
                    return true;
                }
                player.sendMessage("--------------------------------------------------");
                player.sendMessage("GTLevitate is a plugin that gives Levitation and Gliding fun.");
                player.sendMessage("  /gtlev createpad <x> <y> <z> - create a \"scoring pad' centered on the given coordinates");
                return true;
            }
        }
        return true;
    }
}

