/*
 * Decompiled with CFR 0.152.
 */
package com.goaltimellc.plugin.levitate.commands;

import com.goaltimellc.plugin.levitate.GTLevitatePlugin;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class commandGTLevitate
implements CommandExecutor {
    GTLevitatePlugin plugin;

    public commandGTLevitate(GTLevitatePlugin passedPlugin) {
        this.plugin = passedPlugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Logger logger = Logger.getLogger("GTLevitate");
        if (!(sender instanceof Player)) {
            sender.sendMessage("You must be a player to use this command.");
            logger.info("Command sent by non-player");
            return false;
        }
        logger.info("Command sent: " + command.getName() + " by " + sender.getName());
        String configPressurePlate = this.plugin.getConfig().getString("pressurePlate");
        String configPlatformBase = this.plugin.getConfig().getString("platformBase");
        String configPlatformPower = this.plugin.getConfig().getString("platformPower");
        int configLevitationPower = this.plugin.getConfig().getInt("levitationPower");
        int configLevitationDuration = this.plugin.getConfig().getInt("levitationDuration");
        boolean configRequireElytra = this.plugin.getConfig().getBoolean("requireElytra");
        boolean allComponentsAreValid = true;
        Material materialPressurePlate = Material.LIGHT_WEIGHTED_PRESSURE_PLATE;
        try {
            materialPressurePlate = Material.getMaterial((String)configPressurePlate);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        Material materialPlatformBase = Material.PURPUR_BLOCK;
        try {
            materialPlatformBase = Material.getMaterial((String)configPlatformBase);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        Material materialPlatformPower = Material.REDSTONE_BLOCK;
        try {
            materialPlatformPower = Material.getMaterial((String)configPlatformPower);
        }
        catch (IllegalArgumentException e) {
            allComponentsAreValid = false;
        }
        catch (NullPointerException e) {
            allComponentsAreValid = false;
        }
        Player player = (Player)sender;
        if (!allComponentsAreValid) {
            logger.info("INVALID CONFIGURATION FOR gtLevitate PLUGIN");
            player.sendMessage("There is a configuration issue with the gtLevitate Plugin. Contact an Admin.");
            return false;
        }
        String namePressurePlate = materialPressurePlate.toString();
        String namePlatformBase = materialPlatformBase.toString();
        String namePlatformPower = materialPlatformPower.toString();
        player.sendMessage("--------------------------------------------------");
        player.sendMessage("GTLevitate is a plugin that allows you create a platform for initiating levitation:");
        player.sendMessage("   => Place a " + namePressurePlate + " onto a " + namePlatformBase + " that is above a " + namePlatformPower);
        player.sendMessage("   => Stepping onto the pressure plate will initiate (" + configLevitationPower + "x) levitation for " + configLevitationDuration + " seconds");
        if (configRequireElytra) {
            player.sendMessage("   => BUT, only if you are wearing an Elytra!");
        } else {
            player.sendMessage("   => Even if you are NOT wearing an Elytra!");
        }
        player.sendMessage("   => You can stack additional " + namePlatformPower + " below the first one, to increase the strength, up to " + configLevitationPower + " blocks");
        player.sendMessage("--------------------------------------------------");
        return true;
    }
}

