/*
 * Decompiled with CFR 0.152.
 */
package me.Liborsaf.Scoreboard.Managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.Liborsaf.Scoreboard.Commands.SBP;
import me.Liborsaf.Scoreboard.Managers.ConfigManager;
import me.Liborsaf.Scoreboard.Object.Scroller;
import me.Liborsaf.Scoreboard.Text.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class BoardsManager {
    ConfigManager cm;
    ConfigurationSection cs;
    List<String> lines = new ArrayList<String>();
    Map<Player, Scoreboard> boards = new HashMap<Player, Scoreboard>();
    Map<Player, Scroller> scrollers = new HashMap<Player, Scroller>();
    String name;
    String type;
    String color;
    String suffix;
    boolean allowPerm = false;
    String perm = "";

    public void remove(Player player) {
        if (this.boards.containsKey(player)) {
            this.boards.remove(player);
        }
        if (this.scrollers.containsKey(player)) {
            this.scrollers.remove(player);
        }
        if (SBP.toggles.containsKey(player)) {
            SBP.toggles.remove(player);
        }
    }

    public BoardsManager(ConfigManager cm) {
        this.cm = cm;
        this.cs = cm.getConfig("scoreboard.yml").getConfigurationSection("Scoreboard");
        this.lines = TextUtil.getLines(this.cs);
        this.name = this.cs.getString("title");
        this.type = this.cs.getString("type");
        this.color = this.cs.getString("color");
        this.suffix = cm.getConfig("settings.yml").getString("Scoreboard.Loading");
        this.allowPerm = cm.getConfig("settings.yml").getBoolean("Permissions.Allow");
        this.perm = cm.getConfig("settings.yml").getString("Permissions.View");
    }

    public void createBoard(Player player) {
        if (this.allowPerm && !player.hasPermission(this.perm)) {
            return;
        }
        if (this.boards.containsKey(player)) {
            this.boards.remove(player);
        }
        ScoreboardManager sbm = Bukkit.getServer().getScoreboardManager();
        Scoreboard sb = sbm.getNewScoreboard();
        Objective obj = sb.registerNewObjective("SBP", "dummy");
        String SBName = TextUtil.replacePlaceholders(player, this.name, this.cm);
        obj.setDisplayName(SBName);
        obj.setDisplaySlot(DisplaySlot.valueOf((String)this.type));
        String list = "";
        int i = 0;
        while (i < this.lines.size()) {
            String line = TextUtil.replacePlaceholders(player, this.lines.get(this.lines.size() - (i + 1)), this.cm);
            if (line.length() > 16) {
                OfflinePlayer op = Bukkit.getServer().getOfflinePlayer(line);
                Score score = obj.getScore(op);
                score.setScore(i - 1);
            } else {
                list = String.valueOf(list) + TextUtil.replaceColors(this.color);
                Team t = sb.registerNewTeam("SBP" + i);
                t.addEntry(list);
                t.setPrefix(line);
                t.setSuffix(TextUtil.replaceColors(this.suffix));
                obj.getScore(list).setScore(i);
            }
            ++i;
        }
        player.setScoreboard(sb);
        this.boards.put(player, sb);
        this.scrollers.put(player, new Scroller(this.name, 16, 5, '&'));
        SBP.toggles.put(player, true);
        this.updateTeams(player);
    }

    public void updateTeams(Player player) {
        if (this.boards.containsKey(player) && SBP.toggles.get(player).booleanValue()) {
            Scoreboard sb = this.boards.get(player);
            Objective obj = sb.getObjective(DisplaySlot.valueOf((String)this.type));
            String SBName = TextUtil.replacePlaceholders(player, this.name, this.cm);
            if (this.cm.getConfig("settings.yml").getBoolean("Scoreboard.Scroll") && this.scrollers.containsKey(player)) {
                obj.setDisplayName(this.scrollers.get(player).next());
            } else {
                obj.setDisplayName(SBName);
            }
            int i = 0;
            while (i < this.lines.size()) {
                String line = TextUtil.replacePlaceholders(player, this.lines.get(this.lines.size() - (i + 1)), this.cm);
                Team t = sb.getTeam("SBP" + i);
                if (t != null) {
                    if (line.length() > 16) {
                        OfflinePlayer op = Bukkit.getServer().getOfflinePlayer(line);
                        Score score = obj.getScore(op);
                        score.setScore(i);
                    } else {
                        t.setPrefix(line);
                    }
                    t.setSuffix("");
                }
                ++i;
            }
        }
    }
}

