/*
 * Decompiled with CFR 0.152.
 */
package com.jimby.cleanbans.managers;

import com.jimby.cleanbans.managers.MessageManager;
import com.jimby.cleanbans.utils.TimeChecker;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class SettingsManager {
    static SettingsManager instance = new SettingsManager();
    Plugin p;
    FileConfiguration config;
    File cfile;
    protected boolean l;

    public static SettingsManager getInstance() {
        return instance;
    }

    public void setup(Plugin p) {
        this.config = p.getConfig();
        this.config.options().copyDefaults(true);
        this.cfile = new File(p.getDataFolder(), "config.yml");
        this.saveConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean checkBan(String player) {
        if (this.getConfig().getBoolean("bans." + player.toLowerCase() + ".banned")) {
            if (this.getConfig().getString("bans." + player.toLowerCase() + ".until") != null) {
                return TimeChecker.check(player);
            }
            return true;
        }
        return false;
    }

    public void unban(CommandSender sender, String player, String unbannedBy) {
        if (this.checkBan(player)) {
            this.getConfig().set("bans." + player.toLowerCase() + ".banned", (Object)false);
            MessageManager.getInstance().sendBanMessage(sender, ChatColor.GREEN + player + ChatColor.DARK_GRAY + " has been unbanned by " + ChatColor.GREEN + unbannedBy + ".", this.getConfig().getBoolean("broadcast.unban"));
            this.saveConfig();
        } else {
            MessageManager.getInstance().sendErrorMessage(sender, String.valueOf(player) + " isn't banned.");
        }
    }

    public String getBanReason(String player) {
        return this.getConfig().getString("bans." + player.toLowerCase() + ".reason");
    }

    public String getBanDate(String player) {
        return this.getConfig().getString("bans." + player.toLowerCase() + ".date");
    }

    public String getBannedBy(String player) {
        return this.getConfig().getString("bans." + player.toLowerCase() + ".bannedby");
    }

    public void ban(CommandSender sender, String player, String bannedBy, String date, String banMessage) {
        if (!this.checkBan(player)) {
            this.getConfig().set("bans." + player.toLowerCase() + ".banned", (Object)true);
            this.getConfig().set("bans." + player.toLowerCase() + ".bannedby", (Object)bannedBy);
            this.getConfig().set("bans." + player.toLowerCase() + ".date", (Object)date);
            this.getConfig().set("bans." + player.toLowerCase() + ".reason", (Object)banMessage);
            MessageManager.getInstance().sendBanMessage(sender, ChatColor.GREEN + player + ChatColor.DARK_GRAY + " has been banned by " + ChatColor.GREEN + bannedBy, this.getConfig().getBoolean("broadcast.ban"));
            this.saveConfig();
            String kickMsg = ChatColor.DARK_GRAY + "[" + ChatColor.GREEN + "CleanBans" + ChatColor.DARK_GRAY + "]" + " You have been banned on this server for " + ChatColor.GREEN + SettingsManager.getInstance().getBanReason(player) + " \n" + ChatColor.DARK_GRAY + "Donate for an unban @\n" + ChatColor.GREEN + "http://donate.cleanfactions.com/";
            Player bannedPlayer = Bukkit.getServer().getPlayer(player);
            if (bannedPlayer != null) {
                bannedPlayer.kickPlayer(kickMsg);
            }
        } else {
            MessageManager.getInstance().sendErrorMessage(sender, String.valueOf(player) + " is already banned.");
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.cfile);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save config.yml!");
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.cfile);
        this.config.options().copyDefaults(true);
    }

    public PluginDescriptionFile getDesc() {
        return this.p.getDescription();
    }

    public void tempBan(CommandSender sender, String player, String bannedBy, String date, String banMessage, String banTime) {
        if (!this.checkBan(player)) {
            this.getConfig().set("bans." + player.toLowerCase() + ".banned", (Object)true);
            this.getConfig().set("bans." + player.toLowerCase() + ".bannedby", (Object)bannedBy);
            this.getConfig().set("bans." + player.toLowerCase() + ".date", (Object)date);
            this.getConfig().set("bans." + player.toLowerCase() + ".reason", (Object)banMessage);
            this.getConfig().set("bans." + player.toLowerCase() + ".until", (Object)banTime);
            MessageManager.getInstance().sendBanMessage(sender, ChatColor.GREEN + player + ChatColor.DARK_GRAY + " has been temp-banned by " + ChatColor.GREEN + bannedBy + ChatColor.DARK_GRAY + " for " + ChatColor.GREEN + banTime, this.getConfig().getBoolean("broadcast.temp-ban"));
            this.saveConfig();
            this.l = TimeChecker.check(player);
            String kickMsg = ChatColor.DARK_GRAY + "[" + ChatColor.GREEN + "CleanBans" + ChatColor.DARK_GRAY + "] " + ChatColor.GREEN + "You have been banned from this server!\n" + ChatColor.GREEN + "Author: " + ChatColor.DARK_GRAY + this.getBannedBy(player) + ", " + ChatColor.GREEN + "Date: " + ChatColor.DARK_GRAY + this.getBanDate(player) + "\n" + ChatColor.GREEN + "Expires in: " + ChatColor.DARK_GRAY + (this.getConfig().getString("bans." + player.toLowerCase() + ".until") != null ? TimeChecker.getTime() : "NEVER") + "\n" + ChatColor.GREEN + "Reason: " + ChatColor.DARK_GRAY + this.getBanReason(player);
            Player bannedPlayer = Bukkit.getServer().getPlayer(player);
            if (bannedPlayer != null) {
                bannedPlayer.kickPlayer(kickMsg);
            }
        } else {
            MessageManager.getInstance().sendErrorMessage(sender, String.valueOf(player) + " is already banned.");
        }
    }
}

