/*
 * Decompiled with CFR 0.152.
 */
package de.TrollonMovie.simpletext;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpigotPluginUpdater {
    public static final String VERSION = "SPU 2.0 by stealth-coders";
    private URL url;
    private final JavaPlugin plugin;
    private final String pluginurl;
    private boolean canceled = false;
    private String version = "";
    private String downloadURL = "";
    private String changeLog = "";
    private boolean out = true;

    public SpigotPluginUpdater(JavaPlugin plugin, String pluginurl) {
        try {
            this.url = new URL(pluginurl);
        }
        catch (MalformedURLException e) {
            this.canceled = true;
            plugin.getLogger().log(Level.WARNING, "Error: Bad URL while checking {0} !", plugin.getName());
        }
        this.plugin = plugin;
        this.pluginurl = pluginurl;
    }

    public void enableOut() {
        this.out = true;
    }

    public void disableOut() {
        this.out = false;
    }

    public boolean needsUpdate() {
        if (this.canceled) {
            return false;
        }
        try {
            URLConnection con = this.url.openConnection();
            InputStream _in = con.getInputStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(_in);
            Node nod = doc.getElementsByTagName("item").item(0);
            NodeList children = nod.getChildNodes();
            this.version = children.item(1).getTextContent();
            this.downloadURL = children.item(3).getTextContent();
            this.changeLog = children.item(5).getTextContent();
            if (this.newVersionAvailiable(this.plugin.getDescription().getVersion(), this.version.replaceAll("[a-zA-z ]", ""))) {
                if (this.out) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7b\u00a7m---------------------------");
                    Bukkit.getConsoleSender().sendMessage("\u00a77 ");
                    Bukkit.getConsoleSender().sendMessage("\u00a76\u00a7lSimpleText \u00a78- \u00a77Neues Update!");
                    Bukkit.getConsoleSender().sendMessage("\u00a77 ");
                    Bukkit.getConsoleSender().sendMessage("\u00a77Deine Version: \u00a7c" + this.plugin.getDescription().getVersion());
                    Bukkit.getConsoleSender().sendMessage("\u00a77Verfuegbare Version: \u00a7c" + this.version.replaceAll("[a-zA-z ]", ""));
                    Bukkit.getConsoleSender().sendMessage("\u00a77Changelog: \u00a7e" + this.changeLog);
                    Bukkit.getConsoleSender().sendMessage("\u00a77 ");
                    Bukkit.getConsoleSender().sendMessage("\u00a77Update jetzt mit \u00a7e/simpletext update\u00a77!");
                    Bukkit.getConsoleSender().sendMessage("\u00a77 ");
                    Bukkit.getConsoleSender().sendMessage("\u00a7b\u00a7m---------------------------");
                }
                return true;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.plugin.getLogger().log(Level.WARNING, "Fehler beim \u00fcberpr\u00fcfen eines neues Updates''{0}''!", this.plugin.getName());
            this.plugin.getLogger().log(Level.WARNING, "Fehler: ", e);
        }
        return false;
    }

    public boolean newVersionAvailiable(String oldv, String newv) {
        if (oldv != null && newv != null) {
            oldv = oldv.replace('.', '_');
            newv = newv.replace('.', '_');
            if (oldv.split("_").length != 0 && oldv.split("_").length != 1 && newv.split("_").length != 0 && newv.split("_").length != 1) {
                int vnum = Integer.valueOf(oldv.split("_")[0]);
                int vsec = Integer.valueOf(oldv.split("_")[1]);
                int newvnum = Integer.valueOf(newv.split("_")[0]);
                int newvsec = Integer.valueOf(newv.split("_")[1]);
                if (newvnum > vnum) {
                    return true;
                }
                if (newvnum == vnum && newvsec > vsec) {
                    return true;
                }
            }
        }
        return false;
    }

    public void update() {
        try {
            URL download = new URL(String.valueOf(this.getFolder(this.pluginurl)) + this.downloadURL);
            BufferedInputStream in = null;
            FileOutputStream fout = null;
            try {
                int count;
                if (this.out) {
                    this.plugin.getLogger().log(Level.INFO, "Versuche runterzuladen von: {0}{1}", new Object[]{this.getFolder(this.pluginurl), this.downloadURL});
                }
                in = new BufferedInputStream(download.openStream());
                fout = new FileOutputStream("plugins/" + this.downloadURL);
                byte[] data = new byte[1024];
                while ((count = in.read(data, 0, 1024)) != -1) {
                    fout.write(data, 0, count);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            if (this.out) {
                this.plugin.getLogger().log(Level.INFO, "File runtergaladen: {0} !", this.downloadURL);
                this.plugin.getLogger().log(Level.INFO, "Damit das Update funktioniert, musst du den Server neustarten!");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Fehler beim Updaten des Plugins!", e);
        }
    }

    public void externalUpdate() {
        try {
            URL download = new URL(this.downloadURL);
            BufferedInputStream in = null;
            FileOutputStream fout = null;
            try {
                int count;
                if (this.out) {
                    this.plugin.getLogger().log(Level.INFO, "Versuche herunterzuladen von {0} ..", this.downloadURL);
                }
                in = new BufferedInputStream(download.openStream());
                fout = new FileOutputStream("plugins/" + this.plugin.getName());
                byte[] data = new byte[1024];
                while ((count = in.read(data, 0, 1024)) != -1) {
                    fout.write(data, 0, count);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            if (this.out) {
                this.plugin.getLogger().log(Level.INFO, "File runtergaladen von: {0} !", this.downloadURL);
                this.plugin.getLogger().log(Level.INFO, "Damit das Update funktioniert, musst du den Server neustarten!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getFolder(String s) {
        return s.substring(0, s.lastIndexOf("/") + 1);
    }
}

