/*
 * Decompiled with CFR 0.152.
 */
package de.photon.effects;

import de.photon.effects.InternalEffect;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainCommand
implements CommandExecutor,
TabExecutor {
    private static final String EFFECTS_PERMISSION_PREFIX = "effects.";
    private static final String PREFIX = ChatColor.DARK_RED + "[Effects] ";
    private static final MainCommand instance = new MainCommand();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(PREFIX + ChatColor.RED + "This plugin can give you permanent effects.");
            sender.sendMessage(PREFIX + ChatColor.GOLD + "Usage: /effects <effect>");
            sender.sendMessage(PREFIX + ChatColor.RED + "Possible effects: \n" + ChatColor.GOLD + String.join((CharSequence)(ChatColor.WHITE + ", \n" + ChatColor.GOLD), InternalEffect.REGISTERED_EFFECTS.keySet()));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(PREFIX + ChatColor.RED + "Only a player can use this command.");
            return true;
        }
        InternalEffect effect = InternalEffect.REGISTERED_EFFECTS.get(args[0].toLowerCase(Locale.ROOT));
        if (effect == null) {
            sender.sendMessage(PREFIX + ChatColor.RED + "Effect not found.");
            sender.sendMessage(PREFIX + ChatColor.RED + "Possible effects: \n" + String.join((CharSequence)", \n", InternalEffect.REGISTERED_EFFECTS.keySet()));
            return true;
        }
        if (!sender.hasPermission(EFFECTS_PERMISSION_PREFIX + effect.getName())) {
            sender.sendMessage(PREFIX + ChatColor.RED + "You don't have permission to do that.");
            return true;
        }
        sender.sendMessage(PREFIX + ChatColor.GOLD + StringUtils.capitalize((String)effect.getName()) + " has been " + (effect.toggleEffects((LivingEntity)((Player)sender)) ? ChatColor.GREEN + "enabled" : ChatColor.RED + "disabled"));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return args.length == 0 ? InternalEffect.REGISTERED_EFFECTS.keySet().stream().filter(name -> sender.hasPermission(EFFECTS_PERMISSION_PREFIX + name)).sorted().collect(Collectors.toUnmodifiableList()) : InternalEffect.REGISTERED_EFFECTS.keySet().stream().filter(key -> StringUtils.startsWithIgnoreCase((String)key, (String)args[0])).filter(name -> sender.hasPermission(EFFECTS_PERMISSION_PREFIX + name)).sorted().collect(Collectors.toList());
    }

    private MainCommand() {
    }

    public static MainCommand getInstance() {
        return instance;
    }
}

