/*
 * Decompiled with CFR 0.152.
 */
package de.photon.effects;

import com.google.common.base.Preconditions;
import de.photon.effects.util.PotionUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class InternalEffect {
    public static final @Unmodifiable Map<String, InternalEffect> REGISTERED_EFFECTS = Stream.of(new InternalEffect("ignoredamage", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.FIRE_RESISTANCE), PotionUtils.permanentEffectFromType(PotionEffectType.DAMAGE_RESISTANCE, 5))), new InternalEffect("nightvision", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.NIGHT_VISION))), new InternalEffect("regeneration", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.REGENERATION, 127))), new InternalEffect("saturation", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.SATURATION, 127))), new InternalEffect("slowfall", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.SLOW_FALLING))), new InternalEffect("speedmine", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.FAST_DIGGING, 127))), new InternalEffect("strength", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.INCREASE_DAMAGE, 127))), new InternalEffect("waterbreathing", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.WATER_BREATHING))), new InternalEffect("weakness", Set.of(PotionUtils.permanentEffectFromType(PotionEffectType.WEAKNESS, 127)))).collect(Collectors.toUnmodifiableMap(InternalEffect::getName, effect -> effect));
    @NotNull
    private final String name;
    private final @Unmodifiable @NotNull Set<PotionEffect> coveredPotions;

    public InternalEffect(@NotNull String name, @NotNull Set<PotionEffect> coveredPotions) {
        Preconditions.checkNotNull((Object)name, (Object)"The name of an InternalEffect must not be null.");
        Preconditions.checkNotNull(coveredPotions, (Object)"The coveredPotions of an InternalEffect must not be null.");
        Preconditions.checkArgument((!coveredPotions.isEmpty() ? 1 : 0) != 0, (Object)"The coveredPotions of an InternalEffect must not be empty.");
        this.name = name;
        this.coveredPotions = Set.copyOf(coveredPotions);
    }

    public boolean toggleEffects(LivingEntity livingEntity) {
        boolean hasAnyEffect = this.coveredPotions.stream().map(PotionEffect::getType).anyMatch(arg_0 -> ((LivingEntity)livingEntity).hasPotionEffect(arg_0));
        if (hasAnyEffect) {
            this.coveredPotions.stream().map(PotionEffect::getType).forEach(arg_0 -> ((LivingEntity)livingEntity).removePotionEffect(arg_0));
        } else {
            this.coveredPotions.forEach(arg_0 -> ((LivingEntity)livingEntity).addPotionEffect(arg_0));
        }
        return !hasAnyEffect;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<PotionEffect> getCoveredPotions() {
        return this.coveredPotions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalEffect)) {
            return false;
        }
        InternalEffect other = (InternalEffect)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "InternalEffect(name=" + this.getName() + ", coveredPotions=" + this.getCoveredPotions() + ")";
    }
}

