/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sneling.snelapi.logger.Logger;

public class ValueInfo {
    private Object value;
    private String name;
    private int modifiers;
    private boolean parameters = false;

    ValueInfo(Field f, Class c) throws IllegalAccessException, InstantiationException {
        Logger.debug(f.getName() + " at " + c.getName());
        f.setAccessible(true);
        this.name = f.getName();
        this.modifiers = f.getModifiers();
        this.value = f.get(c);
    }

    ValueInfo(Method m, Object c) throws InvocationTargetException, IllegalAccessException {
        m.setAccessible(true);
        if (m.getParameterTypes().length == 0) {
            this.value = m.invoke(c, new Object[0]);
        } else {
            this.parameters = true;
        }
        this.name = m.getName();
        this.modifiers = m.getModifiers();
    }

    public boolean hasParameters() {
        return this.parameters;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

