/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sneling.snelapi.util.reflection.ValueInfo;

public class InfoCollector {
    public static List<List<ValueInfo>> getVariables(Class[] cs) throws IllegalAccessException, InstantiationException {
        ArrayList<List<ValueInfo>> values = new ArrayList<List<ValueInfo>>();
        for (Class c : cs) {
            values.add(InfoCollector.getVariables(c));
        }
        return values;
    }

    public static List<ValueInfo> getVariables(Class c) throws IllegalAccessException, InstantiationException {
        ArrayList<ValueInfo> values = new ArrayList<ValueInfo>();
        for (Field f : c.getDeclaredFields()) {
            values.add(new ValueInfo(f, c));
        }
        return values;
    }

    public static List<List<ValueInfo>> getReturnMethods(Class[] cs) throws IllegalAccessException, InvocationTargetException {
        ArrayList<List<ValueInfo>> values = new ArrayList<List<ValueInfo>>();
        for (Class c : cs) {
            values.add(InfoCollector.getReturnMethods(c));
        }
        return values;
    }

    public static List<ValueInfo> getReturnMethods(Object c) throws InvocationTargetException, IllegalAccessException {
        ArrayList<ValueInfo> values = new ArrayList<ValueInfo>();
        for (Method m : c.getClass().getDeclaredMethods()) {
            values.add(new ValueInfo(m, c.getClass()));
        }
        return values;
    }
}

