/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.util.identifiable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class IDUtil {
    public static String toID(String s) {
        return s.toLowerCase().replaceAll("_", ".");
    }

    public static String generateRandomID(int length) {
        return IDUtil.generateRandomID(length, true, true, true, false);
    }

    public static String generateRandomID(int length, boolean lowerCase, boolean upperCase, boolean digits, boolean symbols) {
        String res = "";
        for (int i = 0; i < length; ++i) {
            res = res + IDUtil.generateRandomCharacter(lowerCase, upperCase, digits, symbols);
        }
        return res;
    }

    private static char generateRandomCharacter(boolean lowerCase, boolean upperCase, boolean digits, boolean symbols) throws IllegalArgumentException {
        if (!(lowerCase || upperCase || digits || symbols)) {
            throw new IllegalArgumentException("You must allow least one of the allowed types of characters.");
        }
        List<Character> allowedCharacters = new ArrayList<Character>();
        String letters = "abcdefghijklmnopqrstuvwxyz";
        if (lowerCase) {
            allowedCharacters = IDUtil.addAll(letters.toCharArray(), allowedCharacters);
        }
        if (upperCase) {
            allowedCharacters = IDUtil.addAll(letters.toUpperCase().toCharArray(), allowedCharacters);
        }
        if (digits) {
            allowedCharacters = IDUtil.addAll("0123456789".toCharArray(), allowedCharacters);
        }
        if (symbols) {
            allowedCharacters = IDUtil.addAll(",./<>?;':[]{}|`~!@#$%^&*()_+-=".toCharArray(), allowedCharacters);
        }
        Random r = new Random(System.nanoTime());
        Collections.shuffle(allowedCharacters, r);
        return allowedCharacters.get(r.nextInt(allowedCharacters.size())).charValue();
    }

    private static List<Character> addAll(char[] array, List<Character> list) {
        for (char c : array) {
            list.add(Character.valueOf(c));
        }
        return list;
    }
}

