/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.plugin;

import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.PluginState;
import net.sneling.snelapi.plugin.exceptions.PluginIllegalStateChangeException;
import net.sneling.snelapi.util.StringUtil;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SnelPlugin
extends JavaPlugin {
    private final String name;
    private final String shortName;
    private final String pluginHash;
    private final String version;
    private String author = StringUtil.toString(this.getDescription().getAuthors());
    private PluginState state = PluginState.DISABLED;

    protected SnelPlugin(String name, String shortName, String version, String hash) {
        this.name = name;
        this.shortName = shortName;
        this.pluginHash = hash.toLowerCase().replaceAll(" ", "-");
        this.version = version;
    }

    public final void onLoad() {
        try {
            if (this.getState() != PluginState.DISABLED) {
                throw new PluginIllegalStateChangeException(this, PluginState.LOADING);
            }
            this.setState(PluginState.LOADING);
            this.onPluginLoad();
            this.setState(PluginState.LOADED);
        }
        catch (Exception e) {
            Logger.error("An error occured while loading " + this.getPluginName() + ". Full Error:", this);
            e.printStackTrace();
            this.setState(PluginState.POST_ERROR);
        }
    }

    public final void onEnable() {
        try {
            if (this.getState() != PluginState.LOADED) {
                throw new PluginIllegalStateChangeException(this, PluginState.ENABLING);
            }
            this.setState(PluginState.ENABLING);
            this.onPluginEnable();
            this.setState(PluginState.ENABLED);
            Logger.log("\u001b[32;1m" + this.getPluginName() + " has successfully enabled.", this);
        }
        catch (Exception e) {
            Logger.error("An error occured while enabling " + this.getPluginName() + ". Full Error:", this);
            e.printStackTrace();
            this.setState(PluginState.POST_ERROR);
        }
    }

    public final void onDisable() {
        try {
            if (this.getState() == PluginState.DISABLED && !this.isEnabled()) {
                throw new PluginIllegalStateChangeException(this, PluginState.DISABLING);
            }
            this.setState(PluginState.DISABLING);
            this.onPluginDisable();
            this.setState(PluginState.DISABLED);
        }
        catch (Exception e) {
            Logger.error("An error occured while disabling " + this.getPluginName() + ". Full Error:", this);
            e.printStackTrace();
            this.setState(PluginState.POST_ERROR);
        }
    }

    protected void onPluginLoad() throws Exception {
    }

    protected void onPluginEnable() throws Exception {
    }

    protected void onPluginDisable() throws Exception {
    }

    public String getAuthor() {
        return this.author;
    }

    protected final void setAuthor(String author) {
        this.author = author;
    }

    protected boolean register() {
        return SnelAPI.getAPI().getPluginManager().registerPlugin(this);
    }

    protected final boolean registerCommand(SnelCommand cmd) {
        return SnelAPI.getAPI().getCommandManager().registerCommand(cmd, this);
    }

    public final String getPluginName() {
        return this.name;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getPluginHash() {
        return this.pluginHash;
    }

    public final String getVersion() {
        return this.version;
    }

    public final PluginState getState() {
        return this.state;
    }

    private void setState(PluginState state) {
        this.state = state;
        Logger.debug("\u001b[32;1mThe plugin is now " + state.getName() + ".", this);
        if (state == PluginState.DISABLED || state == PluginState.POST_ERROR) {
            this.setEnabled(false);
        }
    }
}

