/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.plugin;

import java.util.ArrayList;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.SnelPlugin;

public class PluginManager {
    private final ArrayList<SnelPlugin> plugins = new ArrayList();

    final boolean registerPlugin(SnelPlugin plugin) {
        if (this.isRegistered(plugin)) {
            Logger.error("Failed to register plugin '" + plugin.getPluginName() + "' as it was already registered, or that a plugin with the same hash was already registered.");
            return false;
        }
        this.plugins.add(plugin);
        Logger.debug("\u001b[32;1mSuccessfully registered plugin '" + plugin.getPluginName() + "' into the API.");
        return true;
    }

    public final int getRegisteredPluginsSize() {
        return this.plugins.size();
    }

    public final ArrayList<SnelPlugin> getPlugins() {
        return this.plugins;
    }

    public final SnelPlugin getPlugin(String hash) {
        for (SnelPlugin plugin : this.plugins) {
            if (!plugin.getPluginHash().equals(hash.toLowerCase())) continue;
            return plugin;
        }
        return null;
    }

    public final SnelPlugin getPluginByName(String name) {
        for (SnelPlugin plugin : this.getPlugins()) {
            if (!plugin.getPluginName().equalsIgnoreCase(name)) continue;
            return plugin;
        }
        return null;
    }

    public final boolean isRegistered(SnelPlugin plugin) {
        return this.getPlugin(plugin.getPluginHash()) != null;
    }
}

