/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.permission;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.sneling.snelapi.a.internal.SnelAPIInternal;
import net.sneling.snelapi.file.text.SnelTextFile;
import net.sneling.snelapi.permission.SnelPermission;
import net.sneling.snelapi.plugin.SnelPlugin;
import net.sneling.snelapi.util.identifiable.IDUtil;

public abstract class SnelPermissionParent
extends SnelTextFile {
    private String prefix;

    public SnelPermissionParent(String prefix, SnelPlugin plugin) {
        this(prefix, prefix + "-permissions", plugin);
    }

    public SnelPermissionParent(String prefix, String filename, SnelPlugin plugin) {
        super(plugin, new File(plugin.getDataFolder() + "/" + filename + ".csv"));
        try {
            this.prefix = prefix;
            this.setupIDs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupIDs() throws Exception {
        List<SnelPermission> values = this.getValues();
        if (SnelAPIInternal.getInstance().getPluginConfig().getConfig().getBoolean("print.permissions", false)) {
            this.openWriter(true);
            this.addLine("Permission,Description");
            for (SnelPermission perm : values) {
                this.addLine(perm.getID() + "," + perm.getDescription());
            }
            this.closeWriter();
        }
    }

    final List<SnelPermission> getValues() throws IllegalAccessException {
        ArrayList<SnelPermission> values = new ArrayList<SnelPermission>();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (!f.getType().equals(SnelPermission.class)) continue;
            SnelPermission perm = (SnelPermission)f.get(this.getClass());
            if (perm == null) {
                perm = new SnelPermission();
            }
            values.add(perm.setID(this.prefix + "." + IDUtil.toID(f.getName())));
            f.set(this.getClass(), perm);
        }
        return values;
    }
}

