/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.logger;

import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.a.internal.SnelAPIInternal;
import net.sneling.snelapi.plugin.SnelPlugin;

public class Logger {
    private static final String ERR = "\u001b[31;1m[ERROR] ";
    private static final String DEBUG = "\u001b[36;1m[DEBUG] \u001b[0m";

    public static void log(Object obj) {
        Logger.log(obj, SnelAPIInternal.getInstance());
    }

    public static void log(Object obj, SnelPlugin plugin) {
        Logger.print("[" + plugin.getShortName() + "] " + obj + "\u001b[0m");
    }

    public static void debug(Object obj) {
        Logger.debug(obj, SnelAPIInternal.getInstance());
    }

    public static void debug(Object obj, SnelPlugin plugin) {
        if (SnelAPI.getAPI().isDebugEnabled()) {
            Logger.log(DEBUG + obj + "\u001b[0m", plugin);
        }
    }

    public static void error(Object obj) {
        Logger.error(obj, SnelAPIInternal.getInstance());
    }

    public static void error(Object obj, SnelPlugin plugin) {
        Logger.log(ERR + obj + "\u001b[0m", plugin);
    }

    public static void print(Object obj) {
        System.out.println(obj + "\u001b[0m");
    }
}

