/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.language;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.sneling.snelapi.file.yml.SnelYMLConfig;
import net.sneling.snelapi.language.SnelLanguage;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.SnelPlugin;
import net.sneling.snelapi.util.identifiable.IDUtil;
import org.apache.commons.lang.Validate;

public abstract class SnelLanguageParent
extends SnelYMLConfig {
    private String prefix;

    public SnelLanguageParent(String prefix, SnelPlugin plugin) {
        this(prefix, prefix, plugin);
    }

    public SnelLanguageParent(String prefix, String fileName, SnelPlugin plugin) {
        super(plugin, fileName, true);
        Validate.notNull((Object)((Object)plugin), (String)"The plugin is null!");
        this.prefix = prefix;
    }

    @Override
    public void loadFromFile() throws IllegalAccessException {
        for (SnelLanguage lang : this.getAllValues()) {
            if (!this.getConfig().isSet(lang.getId()) && lang.isConfigurable()) {
                this.getConfig().set(lang.getId(), (Object)lang.get());
                Logger.debug("Added default Language Variable for " + lang.getId());
            }
            lang.setValue(this.getConfig().getString(lang.getId(), lang.get()));
        }
    }

    public final List<SnelLanguage> getAllValues() throws IllegalAccessException {
        ArrayList<SnelLanguage> values = new ArrayList<SnelLanguage>();
        Class<?> parent = this.getClass();
        for (Field field : parent.getDeclaredFields()) {
            if (!field.getType().equals(SnelLanguage.class) || Modifier.isPrivate(field.getModifiers())) continue;
            SnelLanguage current = (SnelLanguage)field.get(parent);
            values.add(current.setId(IDUtil.toID(this.getPrefix() + "." + field.getName())));
        }
        return values;
    }

    private String getPrefix() {
        return this.prefix;
    }
}

