/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.language.SnelLanguageParent;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.SnelPlugin;
import org.apache.commons.lang.Validate;

public class LanguageManager {
    private HashMap<SnelPlugin, List<SnelLanguageParent>> registeredParents = new HashMap();

    final void registerParent(SnelLanguageParent parent) {
        Validate.notNull((Object)parent);
        if (!SnelAPI.getAPI().getPluginManager().isRegistered(parent.getPlugin())) {
            Logger.error(parent.getPlugin().getPluginName() + " tried to register a Language Configuration but wasn't recognized by the api.");
            return;
        }
        if (this.getRegisteredParents(parent.getPlugin()).contains(parent)) {
            Logger.error("There is already a Language Configuration registered for '" + parent.getClass().getName() + "'! Aborting registration.");
            return;
        }
        List<SnelLanguageParent> parents = this.registeredParents.get((Object)parent.getPlugin());
        if (parents == null) {
            parents = new ArrayList<SnelLanguageParent>();
        }
        parents.add(parent);
        this.registeredParents.put(parent.getPlugin(), parents);
        Logger.debug("\u001b[32;1mRegistered Language Configuration " + parent.getClass().getName());
    }

    public List<SnelLanguageParent> getRegisteredParents(SnelPlugin plugin) {
        return this.registeredParents.get((Object)plugin);
    }

    public Collection<List<SnelLanguageParent>> getRegisteredParents() {
        return this.registeredParents.values();
    }
}

