/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.file.yml;

import java.util.ArrayList;
import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.file.yml.SnelYMLConfig;
import net.sneling.snelapi.logger.Logger;

public class YMLConfigHandler {
    private static final ArrayList<SnelYMLConfig> registeredConfigs = new ArrayList();

    public static boolean registerConfig(SnelYMLConfig config) {
        if (!SnelAPI.getAPI().getPluginManager().isRegistered(config.getPlugin())) {
            Logger.error("The plugin '" + config.getPlugin().getPluginName() + "' tried to register a config but wasn't recognized by the API.");
            return false;
        }
        if (YMLConfigHandler.isRegistered(config)) {
            Logger.error("There is already a config registered for '" + config.getFile().getPath() + "'! Aborting registration for this config.");
            return false;
        }
        registeredConfigs.add(config);
        Logger.debug("\u001b[32;1mRegistered config for '" + config.getFile().getPath() + "'");
        return true;
    }

    private static boolean isRegistered(SnelYMLConfig config) {
        for (SnelYMLConfig check : YMLConfigHandler.getRegisteredConfigs()) {
            if (!check.getFileName().equals(config.getFileName()) || !check.getPlugin().getDataFolder().equals(config.getPlugin().getDataFolder())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<SnelYMLConfig> getRegisteredConfigs() {
        return registeredConfigs;
    }
}

