/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.file.yml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sneling.snelapi.file.SnelFile;
import net.sneling.snelapi.file.exceptions.DefaultNotFoundException;
import net.sneling.snelapi.file.yml.YMLConfigHandler;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.SnelPlugin;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SnelYMLConfig
extends SnelFile {
    private FileConfiguration config;
    private final boolean loadFromFile;

    protected SnelYMLConfig(SnelPlugin plugin, String fileName, boolean loadFromFile) {
        this(plugin, new File(plugin.getDataFolder() + "/" + fileName + ".yml"), loadFromFile);
    }

    public SnelYMLConfig(SnelPlugin plugin, File file, boolean loadFromFile) {
        super(plugin, file);
        this.loadFromFile = loadFromFile;
        YMLConfigHandler.registerConfig(this);
    }

    final void setup() throws Exception {
        if (!this.getPlugin().getDataFolder().exists()) {
            Logger.debug("Creating folder for plugin '" + this.getPlugin().getPluginName() + "'.", this.getPlugin());
            this.getPlugin().getDataFolder().mkdirs();
            Logger.debug("\u001b[32;1mCreated folder for plugin '" + this.getPlugin().getPluginName() + "'.", this.getPlugin());
        }
        if (!this.getFile().exists()) {
            Logger.debug("Creating YML Config file at '" + this.getFile().getPath() + "'.", this.getPlugin());
            this.getFile().createNewFile();
            Logger.debug("\u001b[32;1mCreated YML Config file at '" + this.getFile().getPath() + "'.", this.getPlugin());
        }
        this.load();
        this.save();
        if (this.isLoadFromFile()) {
            Logger.debug("Loading default contents for '" + this.getFileName() + "'", this.getPlugin());
            this.loadFromFile();
            this.save();
            Logger.debug("\u001b[32;1mLoaded default contents for '" + this.getFileName() + "'", this.getPlugin());
        }
    }

    private FileConfiguration getDefaultConfig() {
        return YamlConfiguration.loadConfiguration((InputStream)this.getPlugin().getResource(this.getFileName()));
    }

    protected final SnelYMLConfig setConfig(FileConfiguration config) {
        this.config = config;
        return this;
    }

    public final FileConfiguration getConfig() {
        return this.config;
    }

    private final boolean isLoadFromFile() {
        return this.loadFromFile;
    }

    protected final void save() throws IOException {
        this.config.save(this.getFile());
    }

    protected final void load() {
        this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.getFile()));
        this.postLoad();
    }

    protected void loadFromFile() throws DefaultNotFoundException, IOException, IllegalAccessException {
        FileConfiguration temporary = this.getDefaultConfig();
        for (String key : temporary.getKeys(true)) {
            Object obj;
            if (this.config.isSet(key) || (obj = temporary.get(key)) instanceof MemorySection) continue;
            this.config.set(key, obj);
            Logger.debug("[" + this.getFileName() + "] Set Default Value for '" + key + "' to '" + obj + "'");
        }
    }

    protected void postLoad() {
    }
}

