/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.cooldown;

import java.util.HashMap;
import net.sneling.snelapi.cooldown.CooldownAction;
import net.sneling.snelapi.logger.Logger;
import org.bukkit.command.CommandSender;

public class CooldownManager {
    private static HashMap<CommandSender, HashMap<CooldownAction, Long>> cooldowns = new HashMap();

    public static boolean registerCooldown(CommandSender sender, CooldownAction action, long time, OverwriteOption overwriteOption) {
        HashMap<CooldownAction, Long> senderCooldowns;
        Logger.debug("Registering cooldown for " + sender.getName() + " for action " + action.toString() + " for " + time + " ticks");
        if (overwriteOption == OverwriteOption.DISABLED && CooldownManager.getTimeLeft(sender, action) > 0L) {
            Logger.debug("Failed to register cooldown as OverwriteOption == DISABLED and there was already a cooldown registered.");
            return false;
        }
        if (overwriteOption == OverwriteOption.ADDITIVE) {
            time += CooldownManager.getTimeLeft(sender, action);
        }
        if ((senderCooldowns = cooldowns.get(sender)) == null) {
            senderCooldowns = new HashMap();
        }
        senderCooldowns.put(action, time + CooldownManager.getTimeAsTick());
        cooldowns.put(sender, senderCooldowns);
        Logger.debug("New cooldown for " + sender.getName() + " for action " + action.toString() + " set to expire in " + time + " ticks");
        return true;
    }

    public static long getTimeLeft(CommandSender sender, CooldownAction action) {
        HashMap<CooldownAction, Long> current = cooldowns.get(sender);
        if (current == null || current.isEmpty() || !current.containsKey(action)) {
            return 0L;
        }
        long expirationTime = current.get(action);
        if (expirationTime < CooldownManager.getTimeAsTick()) {
            return 0L;
        }
        return expirationTime - CooldownManager.getTimeAsTick();
    }

    private static long getTimeAsTick() {
        return System.currentTimeMillis() / 50L;
    }

    public static long cancelCooldown(CommandSender sender, CooldownAction action) {
        return cooldowns.get(sender).remove(action);
    }

    private static void cleanup() {
    }

    public static enum OverwriteOption {
        ADDITIVE,
        STATIC,
        DISABLED;

    }
}

