/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands.generators;

import java.util.ArrayList;
import java.util.List;
import net.sneling.snelapi.a.internal.lang.APILang;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.logger.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class HelpGenerator {
    private static final int COMMANDS_PER_PAGE = 4;

    public static void sendHelp(CommandSender sender, SnelCommand cmd, int page) {
        Logger.debug("Generating help for command '" + cmd.getName() + "' at page " + page + "' as requested by " + sender.getName());
        sender.sendMessage(HelpGenerator.generateHelp(cmd, sender, page));
    }

    private static String generateHelp(SnelCommand cmd, CommandSender sender, int page) {
        if (!cmd.getPermission().has((Permissible)sender)) {
            return APILang.COMMAND_HELP_NO_PERM.get();
        }
        List<SnelCommand> childs = HelpGenerator.getAvailableArgumentsForPage(cmd, sender, page);
        if (childs == null) {
            if (cmd.getUsage().equals("empty")) {
                return APILang.COMMAND_HELP_NONE.get();
            }
            if (cmd.getUsage().equals("description")) {
                return HelpGenerator.generateHeader(cmd, "Description") + "\n" + HelpGenerator.generateInfo(cmd);
            }
            return HelpGenerator.generateHeader(cmd, "Info") + "\n" + HelpGenerator.generateInfo(cmd);
        }
        if (childs.size() == 0) {
            Logger.debug(sender.getName() + " tried to open help page [" + page + "] for [" + cmd.getName() + "] but it didn't exist for him.");
            return APILang.COMMAND_HELP_NONE.get();
        }
        int nbOfPage = HelpGenerator.getAvailableArguments(cmd, sender).size() % 4 == 0 ? HelpGenerator.getAvailableArguments(cmd, sender).size() / 4 : HelpGenerator.getAvailableArguments(cmd, sender).size() / 4 + 1;
        String info = "";
        if (page == 1) {
            info = HelpGenerator.generateInfo(cmd) + "\n";
        }
        return HelpGenerator.generateHeader(cmd, page + "/" + nbOfPage) + "\n" + info + HelpGenerator.generateHelpList(childs);
    }

    private static String generateInfo(SnelCommand cmd) {
        if (cmd.getUsage().equals("empty")) {
            return "";
        }
        if (cmd.getUsage().equals("description")) {
            return ChatColor.WHITE + " " + cmd.getDescription();
        }
        return ChatColor.GRAY + " Usage: " + cmd.getUsage() + "\n " + ChatColor.GRAY + cmd.getDescription();
    }

    private static String generateHeader(SnelCommand cmd, String info) {
        return "\n" + ChatColor.GRAY + " - " + ChatColor.AQUA + "[Help]" + ChatColor.GRAY + " -- " + ChatColor.YELLOW + cmd.getName() + ChatColor.GRAY + " -- " + ChatColor.YELLOW + info;
    }

    private static List<SnelCommand> getAvailableArguments(SnelCommand cmd, CommandSender sender) {
        ArrayList<SnelCommand> commands = new ArrayList<SnelCommand>();
        if (cmd.getChildCommands() == null || cmd.getChildCommands().isEmpty()) {
            return null;
        }
        for (SnelCommand arg : cmd.getChildCommands()) {
            if (!arg.isVisibleFor(sender)) continue;
            commands.add(arg);
        }
        return commands;
    }

    private static List<SnelCommand> getAvailableArgumentsForPage(SnelCommand cmd, CommandSender sender, int page) {
        List<SnelCommand> availableArguments = HelpGenerator.getAvailableArguments(cmd, sender);
        if (availableArguments == null || availableArguments.isEmpty()) {
            return null;
        }
        ArrayList<SnelCommand> commandsForPage = new ArrayList<SnelCommand>();
        int skip = --page * 4;
        for (int i = 0; i < 4; ++i) {
            try {
                commandsForPage.add(availableArguments.get(skip + i));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        return commandsForPage;
    }

    private static String generateHelpList(List<SnelCommand> cmds) {
        String rslt = "";
        for (SnelCommand cmd : cmds) {
            rslt = rslt + HelpGenerator.generateHelpLine(cmd) + "\n";
        }
        return rslt;
    }

    private static String generateHelpLine(SnelCommand cmd) {
        String name = cmd.getName();
        if (!cmd.getArguments().isEmpty()) {
            name = name + " ...";
        }
        return ChatColor.YELLOW + " " + name + ChatColor.GRAY + " - " + cmd.getDescription();
    }
}

