/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands.arg;

import java.util.ArrayList;
import java.util.List;
import net.sneling.snelapi.commands.arg.ArgRequirement;
import net.sneling.snelapi.commands.arg.ArgType;
import net.sneling.snelapi.util.numbers.DoubleUtil;
import net.sneling.snelapi.util.numbers.IntegerUtil;
import org.bukkit.Bukkit;

public class ArgInfo {
    private final String name;
    private String def;
    private final ArgType type;
    private final List<ArgRequirement> requirements;

    public ArgInfo(String name, ArgType type, ArgRequirement ... requirements) {
        this.name = name;
        this.type = type;
        this.requirements = new ArrayList<ArgRequirement>();
        for (ArgRequirement requirement : requirements) {
            this.requirements.add(requirement);
        }
    }

    public final String getDefault() {
        return this.def;
    }

    public final ArgInfo setDefault(String def) {
        this.def = def;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ArgType getType() {
        return this.type;
    }

    public List<ArgRequirement> getRequirements() {
        return this.requirements;
    }

    public boolean validate(String input) {
        for (ArgRequirement req : this.requirements) {
            switch (req) {
                case PLAYER: {
                    if (Bukkit.getPlayer((String)input) != null) break;
                    return false;
                }
                case INTEGER: {
                    if (IntegerUtil.isInteger(input)) break;
                    return false;
                }
                case DOUBLE: {
                    if (DoubleUtil.isDouble(input)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public String format() {
        if (this.type == ArgType.MENDATORY) {
            return "<" + this.name + this.formatRequirements() + ">";
        }
        return "[" + this.name + this.formatRequirements() + "]";
    }

    public String formatRequirements() {
        if (this.requirements == null || this.requirements.isEmpty()) {
            return "";
        }
        String res = " (";
        for (ArgRequirement requirement : this.requirements) {
            res = res + " & " + requirement.getDisplayName();
        }
        return res.replaceFirst(" & ", "") + ")";
    }
}

