/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sneling.snelapi.a.internal.lang.APILang;
import net.sneling.snelapi.a.internal.permission.APIPerm;
import net.sneling.snelapi.commands.arg.ArgInfo;
import net.sneling.snelapi.commands.arg.ArgType;
import net.sneling.snelapi.commands.generators.HelpGenerator;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.permission.PermChecker;
import net.sneling.snelapi.permission.SnelPermission;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class SnelCommand {
    private String name = "";
    private String description = "No Description Set";
    private final List<String> aliases = new ArrayList<String>();
    private final List<SnelCommand> childCommands = new ArrayList<SnelCommand>();
    private final HashMap<Integer, ArgInfo> arguments = new HashMap();
    private SnelPermission permission = APIPerm.ALL;
    private Class senderType = CommandSender.class;

    protected SnelCommand(String name) {
        this.setName(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean run(CommandSender sender, String[] args) {
        int i;
        ArgInfo argInfo;
        if (!this.senderType.isInstance(sender)) {
            sender.sendMessage(APILang.COMMAND_SENDER_INVALID.get().replaceAll("%TYPE%", this.senderType.getName()));
            return false;
        }
        if (!PermChecker.has((Permissible)sender, this.getPermission())) {
            sender.sendMessage(APILang.COMMAND_NO_PERM.get());
            return false;
        }
        String[] newArgs = new String[this.getArguments().size()];
        Iterator<Integer> i$ = this.getArguments().keySet().iterator();
        do {
            if (!i$.hasNext()) {
                Logger.debug("\u001b[32;1mCommand '" + this.getName() + "' is valid. Executing...");
                this.execute(sender, newArgs);
                return true;
            }
            i = i$.next();
            argInfo = this.getArguments().get(i);
            if (args.length <= i) {
                if (argInfo.getType() != ArgType.OPTIONAL) {
                    sender.sendMessage(APILang.COMMAND_MISSING_ARGUMENTS.get());
                    return false;
                }
                if (argInfo.getDefault() == null && argInfo.getDefault().equals("")) continue;
                newArgs[i] = argInfo.getDefault();
                continue;
            }
            newArgs[i] = args[i];
        } while (argInfo.validate(newArgs[i]));
        sender.sendMessage(APILang.COMMAND_ARGUMENT_INVALID.get().replaceAll("%ARG%", argInfo.getName()).replaceAll("%TYPE%", argInfo.formatRequirements()));
        return false;
    }

    protected void execute(CommandSender sender, String[] args) {
        HelpGenerator.sendHelp(sender, this, 1);
    }

    private void setName(String name) {
        this.name = name;
    }

    protected final void setDescription(String description) {
        this.description = description;
    }

    protected final void setPermission(SnelPermission permission) {
        this.permission = permission;
    }

    public final void setForcePlayerExecuter(boolean forcePlayerExecuter) {
        this.senderType = Player.class;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final List<String> getAliases() {
        return this.aliases;
    }

    protected final void addAliases(String ... aliases) {
        for (String s : aliases) {
            this.aliases.add(s.toLowerCase());
        }
    }

    public final List<SnelCommand> getChildCommands() {
        return this.childCommands;
    }

    protected final void addChild(SnelCommand command) {
        this.childCommands.add(command);
        Logger.debug("Registered child '" + command.getName() + "' for command " + this.getName());
    }

    public final HashMap<Integer, ArgInfo> getArguments() {
        return this.arguments;
    }

    protected final int addArgument(ArgInfo arg) {
        int id = this.getNextArgumentId();
        this.arguments.put(id, arg);
        return id;
    }

    private int getNextArgumentId() {
        return this.arguments.size();
    }

    public final SnelPermission getPermission() {
        return this.permission;
    }

    public final boolean isForcePlayerExecuter() {
        return this.senderType == Player.class;
    }

    protected final void setSenderType(Class senderType) {
        this.senderType = senderType;
    }

    public final boolean isVisibleFor(CommandSender sender) {
        return !this.senderType.isInstance(sender) || PermChecker.has((Permissible)sender, this.getPermission());
    }

    public final String getUsage() {
        if (this.description.equals("") && this.getArguments().isEmpty()) {
            return "empty";
        }
        if (!this.description.equals("") && this.getArguments().isEmpty()) {
            return "description";
        }
        String res = this.getName();
        if (this.getArguments() == null) {
            return res;
        }
        if (this.getArguments().values().isEmpty()) {
            return res;
        }
        for (int i = 0; i < this.getArguments().values().size(); ++i) {
            res = res + " " + this.getArguments().get(i).format();
        }
        return res;
    }

    public boolean isValidCall(String call) {
        return this.name.equalsIgnoreCase(call) || this.aliases.contains(call.toLowerCase());
    }
}

