/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands;

import java.io.File;
import java.io.IOException;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.file.text.SnelTextFile;
import net.sneling.snelapi.plugin.SnelPlugin;

class CommandWriter {
    CommandWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnelTextFile writeCommand(SnelCommand command, SnelPlugin plugin) {
        SnelTextFile file = new SnelTextFile(plugin, new File(plugin.getDataFolder() + "/command-" + command.getName() + ".csv"));
        try {
            file.openWriter(true);
            file.addLine("Type,Name,Description,Permission,Usage");
            CommandWriter.writeLines(null, command, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                file.closeWriter();
            }
            catch (Exception exception) {}
        }
        return file;
    }

    private static void writeLines(SnelCommand parent, SnelCommand command, SnelTextFile file) throws IOException {
        CommandWriter.writeSingleLine(parent, command, file);
        for (SnelCommand child : command.getChildCommands()) {
            CommandWriter.writeLines(command, child, file);
        }
    }

    private static void writeSingleLine(SnelCommand parent, SnelCommand command, SnelTextFile file) throws IOException {
        file.addLine(CommandWriter.getLine(parent, command));
    }

    private static String getLine(SnelCommand parent, SnelCommand command) {
        String name = command.getName();
        String description = command.getDescription();
        String permission = command.getPermission().getID();
        String type = parent == null ? "Parent" : "Child of " + parent.getName();
        String usage = command.getUsage().equals("empty") || command.getUsage().equals("description") ? "n/a" : command.getUsage();
        return type + "," + name + "," + description + "," + permission + "," + usage;
    }
}

