/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands;

import java.util.Collection;
import java.util.List;
import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.a.internal.lang.APILang;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.commands.generators.HelpGenerator;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.permission.PermChecker;
import net.sneling.snelapi.util.numbers.IntegerUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

class CommandRunner
implements CommandExecutor {
    CommandRunner() {
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        Logger.debug(sender.getName() + " sent a request for command '" + command.getName() + "'");
        Collection<List<SnelCommand>> commands = SnelAPI.getAPI().getCommandManager().getAllCommands();
        for (List<SnelCommand> cmds : commands) {
            for (SnelCommand cmd : cmds) {
                if (!cmd.isValidCall(command.getName())) continue;
                Logger.debug("Found matching command for '" + cmd.getName() + "', as request by " + sender.getName());
                this.findAndExecuteCommand(cmd, sender, args);
                return true;
            }
        }
        return false;
    }

    private void findAndExecuteCommand(SnelCommand base, CommandSender sender, String[] args) {
        if (!PermChecker.has((Permissible)sender, base.getPermission())) {
            sender.sendMessage(APILang.COMMAND_NO_PERM.get());
            return;
        }
        if (args.length == 0) {
            Logger.debug("Running command '" + base.getName() + "' for " + sender.getName());
            if (!base.run(sender, args)) {
                HelpGenerator.sendHelp(sender, base, 1);
            }
        } else {
            SnelCommand potentialChild = this.getMatchingChild(base, args[0]);
            if (potentialChild == null) {
                if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                    int page = args.length >= 2 ? IntegerUtil.getInt(args[1], 1) : 1;
                    HelpGenerator.sendHelp(sender, base, page);
                } else if (!base.run(sender, args)) {
                    HelpGenerator.sendHelp(sender, base, 1);
                }
            } else {
                Logger.debug("Found child '" + potentialChild.getName() + "' for command '" + base.getName() + "'");
                String[] newArgs = new String[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                this.findAndExecuteCommand(potentialChild, sender, newArgs);
            }
        }
    }

    private SnelCommand getMatchingChild(SnelCommand cmd, String childName) {
        if (cmd.getChildCommands() == null || cmd.getChildCommands().isEmpty()) {
            return null;
        }
        List<SnelCommand> childs = cmd.getChildCommands();
        for (SnelCommand child : childs) {
            if (!child.isValidCall(childName)) continue;
            return child;
        }
        return null;
    }
}

