/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.a.internal.SnelAPIInternal;
import net.sneling.snelapi.commands.CommandRunner;
import net.sneling.snelapi.commands.CommandWriter;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.PluginState;
import net.sneling.snelapi.plugin.SnelPlugin;
import org.bukkit.command.CommandExecutor;

public class CommandManager {
    private final HashMap<SnelPlugin, List<SnelCommand>> commands = new HashMap();
    private final CommandRunner runner = new CommandRunner();

    public boolean registerCommand(SnelCommand cmd, SnelPlugin plugin) {
        if (!SnelAPI.getAPI().getPluginManager().isRegistered(plugin)) {
            Logger.error(plugin.getPluginName() + " tried to register a command but wasn't recognized. by the API.");
            return false;
        }
        if (this.contains(cmd.getName())) {
            Logger.error("There is already a command registered for '" + cmd.getName() + "'! Aborting command registration.");
            return false;
        }
        if (plugin.getState() != PluginState.ENABLING) {
            Logger.error(plugin.getPluginName() + " tried to register a command outside of its onPluginEnable phase. Aborting.");
            return false;
        }
        List<SnelCommand> commandList = this.get(plugin);
        if (commandList == null) {
            commandList = new ArrayList<SnelCommand>();
        }
        commandList.add(cmd);
        this.commands.put(plugin, commandList);
        plugin.getCommand(cmd.getName()).setExecutor((CommandExecutor)this.runner);
        Logger.debug("\u001b[32;1mRegistered command '" + cmd.getName() + "'", plugin);
        if (SnelAPIInternal.getInstance().getPluginConfig().getConfig().getBoolean("print.commands")) {
            CommandWriter.writeCommand(cmd, plugin);
        }
        return true;
    }

    private boolean contains(String cmdName) {
        for (List<SnelCommand> cmds : this.commands.values()) {
            for (SnelCommand cmd : cmds) {
                if (!cmd.getName().equalsIgnoreCase(cmdName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<SnelCommand> get(SnelPlugin plugin) {
        return this.commands.get((Object)plugin);
    }

    public Collection<List<SnelCommand>> getAllCommands() {
        return this.commands.values();
    }
}

