/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.a.internal.commands;

import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.a.internal.SnelAPIInternal;
import net.sneling.snelapi.a.internal.lang.APILang;
import net.sneling.snelapi.a.internal.permission.APIPerm;
import net.sneling.snelapi.commands.SnelCommand;
import net.sneling.snelapi.commands.arg.ArgInfo;
import net.sneling.snelapi.commands.arg.ArgRequirement;
import net.sneling.snelapi.commands.arg.ArgType;
import net.sneling.snelapi.plugin.SnelPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class InfoCommand
extends SnelCommand {
    public InfoCommand() {
        super("info");
        this.addAliases("i", "information");
        this.setPermission(APIPerm.ALL);
        this.addArgument(new ArgInfo("plugin", ArgType.OPTIONAL, new ArgRequirement[0]).setDefault("snelapi"));
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        SnelPlugin plugin = SnelAPI.getAPI().getPluginManager().getPluginByName(args[0]);
        if (plugin == null) {
            sender.sendMessage(APILang.INTERNAL_COMMAND_INFO_INVALID_PLUGIN.get());
            return;
        }
        sender.sendMessage(this.generateInfo(plugin));
    }

    private String generateInfo(SnelPlugin plugin) {
        return "\n" + ChatColor.GRAY + " ---- " + ChatColor.GREEN + "[" + plugin.getPluginName() + " " + plugin.getVersion() + "]" + ChatColor.GRAY + " ---- " + "\n" + ChatColor.GRAY + " Website: " + ChatColor.GREEN + plugin.getDescription().getWebsite() + "\n" + ChatColor.GRAY + " Created by: " + ChatColor.GREEN + plugin.getAuthor() + "\n" + ChatColor.GRAY + " Plugin Hash: " + ChatColor.GREEN + plugin.getPluginHash() + "\n" + ChatColor.GRAY + " Running with " + ChatColor.GREEN + "SnelAPI (v" + SnelAPIInternal.getInstance().getVersion() + ")";
    }
}

