/*
 * Decompiled with CFR 0.152.
 */
package net.sneling.snelapi.a.internal;

import net.sneling.snelapi.SnelAPI;
import net.sneling.snelapi.a.internal.commands.SnelAPICommand;
import net.sneling.snelapi.a.internal.config.InternalConfig;
import net.sneling.snelapi.a.internal.lang.APILang;
import net.sneling.snelapi.a.internal.permission.APIPerm;
import net.sneling.snelapi.logger.Logger;
import net.sneling.snelapi.plugin.SnelPlugin;

public class SnelAPIInternal
extends SnelPlugin {
    private static SnelAPIInternal instance;
    private static SnelAPI api;
    private APILang apiLang;
    private APIPerm apiPerm;
    private InternalConfig config;

    public SnelAPIInternal() throws Exception {
        super("SnelAPI", "S-API", "1.0", "sneling-snelapi");
        this.setAuthor("Sneling");
        instance = this;
        api = new SnelAPI();
        this.register();
        this.config = new InternalConfig();
        Logger.debug("\u001b[32;1mSnelAPI has been assigned. If, for any reason (except turning off debugging) you don't see this message when turning your server on again, please make sure that the plugin has been successfully loaded.");
        this.apiLang = new APILang();
    }

    @Override
    public void onPluginLoad() throws Exception {
        api.loadAPI();
    }

    @Override
    public void onPluginEnable() throws Exception {
        api.enableAPI();
        api.setDebug(this.getPluginConfig().getConfig().getBoolean("debug", true));
        this.apiPerm = new APIPerm();
        this.registerCommand(new SnelAPICommand());
    }

    @Override
    public void onPluginDisable() {
        api.disableAPI();
    }

    public final InternalConfig getPluginConfig() {
        return this.config;
    }

    public static SnelAPIInternal getInstance() {
        return instance;
    }
}

