/*
 * Decompiled with CFR 0.152.
 */
package net.nikdev.launchpads.pad;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.nikdev.launchpads.LaunchPads;
import net.nikdev.launchpads.pad.LaunchPad;
import net.nikdev.launchpads.util.Conditions;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;

public class LaunchPadManager {
    private final LaunchPads plugin;
    private final List<LaunchPad> launchPads = new ArrayList<LaunchPad>();
    private final Set<UUID> recent = new HashSet<UUID>();

    public LaunchPadManager(LaunchPads plugin) {
        this.plugin = plugin;
        this.load();
    }

    public List<LaunchPad> getLaunchPads() {
        return Collections.unmodifiableList(this.launchPads);
    }

    public Set<UUID> getRecent() {
        return this.recent;
    }

    private void load() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("Launch-Pads");
        if (section != null && !section.getKeys(false).isEmpty()) {
            section.getKeys(false).forEach(key -> {
                ConfigurationSection pad = section.getConfigurationSection(key);
                if (!Conditions.notNull(pad.getString("Bottom-Material")) || !Conditions.notNull(Material.matchMaterial((String)pad.getString("Bottom-Material")) == null)) {
                    this.plugin.getLogger().severe("Error loading launch pad: " + key + ", bottom material must be a valid material.");
                    return;
                }
                Sound sound = null;
                if (Conditions.notNull(pad.getString("Sound-Played"))) {
                    try {
                        sound = Sound.valueOf((String)pad.getString("Sound-Played"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.launchPads.add(new LaunchPad(Material.matchMaterial((String)pad.getString("Bottom-Material")), pad.getInt("Multiplier", 1), Material.matchMaterial((String)pad.getString("Top-Material")), sound, pad.getString("Permission-Needed", "")));
            });
        }
        this.plugin.getLogger().info(this.getLaunchPads().size() + " Launch Pad(s) successfully loaded!");
    }
}

