/*
 * Decompiled with CFR 0.152.
 */
package net.nikdev.launchpads.listeners;

import net.nikdev.launchpads.LaunchPads;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerMove
implements Listener {
    private final LaunchPads plugin;

    public PlayerMove(LaunchPads plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        this.plugin.getLaunchPadManager().getLaunchPads().forEach(pad -> {
            if (p.getLocation().getBlock().getRelative(0, -1, 0).getType().equals((Object)pad.getBottom())) {
                if (pad.getTop().isPresent() && p.getLocation().getBlock().getType() != pad.getTop().get()) {
                    return;
                }
                if (!pad.getPermission().isEmpty() && !p.hasPermission(pad.getPermission())) {
                    return;
                }
                if (pad.getSound().isPresent()) {
                    p.getWorld().playSound(p.getLocation(), pad.getSound().get(), 3.0f, 1.0f);
                }
                p.setVelocity(p.getLocation().getDirection().multiply(pad.getMultiplier()).setY(p.getLocation().getDirection().getY() + (double)(pad.getMultiplier() / 3)));
                if (this.plugin.getConfig().getInt("Fall-Protection-Time") > 0) {
                    this.plugin.getLaunchPadManager().getRecent().add(p.getUniqueId());
                    new BukkitRunnable(){

                        public void run() {
                            PlayerMove.this.plugin.getLaunchPadManager().getRecent().remove(p.getUniqueId());
                        }
                    }.runTaskLater((Plugin)this.plugin, (long)this.plugin.getConfig().getInt("Fall-Protection-Time"));
                }
            }
        });
    }
}

