/*
 * Decompiled with CFR 0.152.
 */
package me.kieranlington.Utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.kieranlington.Utils.Config;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public interface Utils {
    public static String UUIDtoName(UUID uuid) {
        if (uuid == null) {
            return "";
        }
        OfflinePlayer p = Bukkit.getServer().getOfflinePlayer(uuid);
        return p.getName();
    }

    public static UUID nameToUUID(String name) {
        UUID uuid = null;
        uuid = Bukkit.getServer().getOfflinePlayer(name).getUniqueId();
        return uuid;
    }

    public static List<String> UUIDsToNames(List<UUID> uuids) {
        ArrayList<String> names = new ArrayList<String>();
        for (UUID u : uuids) {
            names.add(Utils.UUIDtoName(u));
        }
        return names;
    }

    public static List<Integer> MOD(Integer arg1, Integer arg2) {
        int temp = arg1;
        int it = 0;
        while (temp >= arg2) {
            temp -= arg2.intValue();
            ++it;
        }
        return Arrays.asList(temp, it);
    }

    public static Integer DIV(int arg1, int arg2) {
        int t = arg1;
        int i = 0;
        while (t >= arg2) {
            t -= arg2;
            ++i;
        }
        return i;
    }

    public static String materialToString(Material m) {
        if (m == Material.LOG_2) {
            return "Log";
        }
        String s = m.toString().toLowerCase();
        String n = "";
        String[] l = s.split("_");
        if (l.length > 1) {
            l[0] = String.valueOf(l[0]) + " ";
        }
        String[] stringArray = l;
        int n2 = l.length;
        int n3 = 0;
        while (n3 < n2) {
            String str = stringArray[n3];
            n = String.valueOf(n) + str.substring(0, 1).toUpperCase() + str.substring(1);
            ++n3;
        }
        return n;
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    public static Collection<? extends String> getOnlinePlayerNames() {
        ArrayList names = new ArrayList();
        Utils.getOnlinePlayers().forEach(p -> {
            boolean bl = names.add(p.getName());
        });
        return names;
    }

    public static Collection<? extends String> toList(String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            list.add(arg);
            ++n2;
        }
        return list;
    }

    public static List<String> filterList(Collection<? extends String> list, String filter) {
        ArrayList<String> finalList = new ArrayList<String>();
        for (String string : list) {
            if (!string.toLowerCase().startsWith(filter.toLowerCase())) continue;
            finalList.add(string);
        }
        return finalList;
    }

    public static boolean isOnline(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return Bukkit.getOfflinePlayer((UUID)uuid).isOnline();
    }

    public static boolean isOnline(Player player) {
        return player.isOnline();
    }

    public static boolean isOnline(String name) {
        for (Player player : Utils.getOnlinePlayers()) {
            if (!player.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static ChatColor getChatColour(String s) {
        try {
            if (ChatColor.valueOf((String)s) != null) {
                return ChatColor.valueOf((String)s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ChatColor.WHITE;
    }

    public static ChatColor getListColour(String list, String type, Config panels) {
        return Utils.getChatColour(panels.getConfig().getString("lists." + list + "." + type));
    }

    public static Boolean isDoubleChest(Block b) {
        Material bpos1 = b.getLocation().add(-1.0, 0.0, 0.0).getBlock().getType();
        Material bpos2 = b.getLocation().add(1.0, 0.0, 0.0).getBlock().getType();
        Material bpos3 = b.getLocation().add(0.0, 0.0, -1.0).getBlock().getType();
        Material bpos4 = b.getLocation().add(0.0, 0.0, 1.0).getBlock().getType();
        if (bpos1 == Material.CHEST || bpos2 == Material.CHEST || bpos3 == Material.CHEST || bpos4 == Material.CHEST) {
            return true;
        }
        return false;
    }

    public static Block getDoubleChest(Block b) {
        Block bpos1 = b.getLocation().add(-1.0, 0.0, 0.0).getBlock();
        Block bpos2 = b.getLocation().add(1.0, 0.0, 0.0).getBlock();
        Block bpos3 = b.getLocation().add(0.0, 0.0, -1.0).getBlock();
        Block bpos4 = b.getLocation().add(0.0, 0.0, 1.0).getBlock();
        if (bpos1.getType() == Material.CHEST) {
            return bpos1;
        }
        if (bpos2.getType() == Material.CHEST) {
            return bpos2;
        }
        if (bpos3.getType() == Material.CHEST) {
            return bpos3;
        }
        if (bpos4.getType() == Material.CHEST) {
            return bpos4;
        }
        return null;
    }

    public static Block getTargetBlock(Player player, int maxDistance) {
        return player.getTargetBlock(null, maxDistance);
    }

    public static String parseList(List<?> list) {
        int index = 0;
        String parsed = "";
        for (Object obj : list) {
            String str = obj.toString();
            parsed = String.valueOf(parsed) + str + (index != list.size() - 1 ? ", " : "");
            ++index;
        }
        return parsed;
    }

    public static String getTime(Integer str) {
        int seconds = str;
        int days = Utils.DIV(seconds, 86400);
        int hours = Utils.DIV(seconds -= days * 86400, 3600);
        int minutes = Utils.DIV(seconds -= hours * 3600, 60);
        seconds -= minutes * 60;
        String time = "";
        if (days > 0) {
            time = String.valueOf(time) + days + " day" + (days > 1 ? "s " : " ");
        }
        if (hours > 0) {
            time = String.valueOf(time) + hours + " hour" + (hours > 1 ? "s " : " ");
        }
        if (minutes > 0) {
            time = String.valueOf(time) + minutes + " minute" + (minutes > 1 ? "s " : " ");
        }
        if (seconds > 0) {
            time = String.valueOf(time) + seconds + " second" + (seconds > 1 ? "s " : " ");
        }
        time = time.length() > 0 ? time.substring(0, time.length() - 1) : time;
        return time;
    }

    public static List<Material> idListToMaterials(List<Integer> IDs) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (int id : IDs) {
            materials.add(Material.getMaterial((int)id));
        }
        return materials;
    }

    public static void broadcastSound(Sound sound) {
        for (Player player : Utils.getOnlinePlayers()) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
    }

    public static void broadcastSounds(List<Sound> sounds) {
        for (Player player : Utils.getOnlinePlayers()) {
            Location loc = player.getLocation();
            for (Sound s : sounds) {
                player.playSound(loc, s, 1.0f, 1.0f);
            }
        }
    }

    public static void playSounds(Player player, List<Sound> sounds) {
        Location loc = player.getLocation();
        for (Sound sound : sounds) {
            player.playSound(loc, sound, 1.0f, 1.0f);
        }
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public static double round(double amount) {
        return Double.parseDouble(new DecimalFormat("#.##").format(amount));
    }

    public static String capitalise(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return String.valueOf(original.substring(0, 1).toUpperCase()) + original.substring(1);
    }

    public static String getJSON(String title) {
        char colorChar = '\u00a7';
        String template = "{\"text\":\"TEXT\",\"color\":\"COLOR\",\"bold\":\"BOLD\",\"underlined\":\"UNDERLINED\",\"italic\":\"ITALIC\",\"strikethrough\":\"STRIKETHROUGH\",\"obfuscated\":\"OBFUSCATED\",\"extra\":[EXTRA]}";
        String json = "";
        ArrayList<String> parts = new ArrayList<String>();
        int first = 0;
        int last = 0;
        while ((first = title.indexOf(colorChar, last)) != -1) {
            int offset = 2;
            while ((last = title.indexOf(colorChar, first + offset)) - 2 == first) {
                offset += 2;
            }
            if (last == -1) {
                parts.add(title.substring(first));
                break;
            }
            parts.add(title.substring(first, last));
        }
        if (parts.isEmpty()) {
            parts.add(title);
        }
        Pattern colorFinder = Pattern.compile("(" + colorChar + "([a-f0-9]))");
        for (String part : parts) {
            json = json.isEmpty() ? template : json.replace("EXTRA", template);
            Matcher matcher = colorFinder.matcher(part);
            ChatColor color = matcher.find() ? ChatColor.getByChar((char)matcher.group().charAt(1)) : ChatColor.WHITE;
            json = json.replace("COLOR", color.name().toLowerCase());
            json = json.replace("BOLD", String.valueOf(part.contains(ChatColor.BOLD.toString())));
            json = json.replace("ITALIC", String.valueOf(part.contains(ChatColor.ITALIC.toString())));
            json = json.replace("UNDERLINED", String.valueOf(part.contains(ChatColor.UNDERLINE.toString())));
            json = json.replace("STRIKETHROUGH", String.valueOf(part.contains(ChatColor.STRIKETHROUGH.toString())));
            json = json.replace("OBFUSCATED", String.valueOf(part.contains(ChatColor.MAGIC.toString())));
            json = json.replace("TEXT", part.replaceAll("(" + colorChar + "([a-z0-9]))", ""));
        }
        json = json.replace(",\"extra\":[EXTRA]", "");
        return json;
    }

    public static boolean containsIgnoreCase(String str, List<String> list) {
        for (String item : list) {
            if (!item.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }
}

