/*
 * Decompiled with CFR 0.152.
 */
package me.kieranlington.Utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.kieranlington.Utils.ArrayWrapper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class Reflection {
    private static final Map<String, Class<?>> _loadedNMSClasses = new HashMap();
    private static final Map<String, Class<?>> _loadedOBCClasses = new HashMap();
    private static final Map<Class<?>, Map<String, Field>> _loadedFields = new HashMap();
    private static final Map<Class<?>, Map<String, Map<ArrayWrapper<Class<?>>, Method>>> _loadedMethods = new HashMap();

    public static synchronized String getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String version = String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".";
        return version;
    }

    public static synchronized Class<?> getNMSClass(String className) {
        if (_loadedNMSClasses.containsKey(className)) {
            return _loadedNMSClasses.get(className);
        }
        String fullName = "net.minecraft.server." + Reflection.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
            _loadedNMSClasses.put(className, null);
            return null;
        }
        _loadedNMSClasses.put(className, clazz);
        return clazz;
    }

    public static synchronized Class<?> getOBCClass(String className) {
        if (_loadedOBCClasses.containsKey(className)) {
            return _loadedOBCClasses.get(className);
        }
        String fullName = "org.bukkit.craftbukkit." + Reflection.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
            _loadedOBCClasses.put(className, null);
            return null;
        }
        _loadedOBCClasses.put(className, clazz);
        return clazz;
    }

    public static synchronized Object getHandle(Object obj) {
        try {
            return Reflection.getMethod(obj.getClass(), "getHandle", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized Field getField(Class<?> clazz, String name) {
        Map<Object, Object> loaded;
        if (!_loadedFields.containsKey(clazz)) {
            loaded = new HashMap();
            _loadedFields.put(clazz, loaded);
        } else {
            loaded = _loadedFields.get(clazz);
        }
        if (loaded.containsKey(name)) {
            return (Field)loaded.get(name);
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            loaded.put(name, field);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            loaded.put(name, null);
            return null;
        }
    }

    public static synchronized Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        ArrayWrapper wrappedArg;
        Map<ArrayWrapper<Class<?>>, Method> loadedSignatures;
        Map<String, Map<ArrayWrapper<Class<?>>, Method>> loadedMethodNames;
        if (!_loadedMethods.containsKey(clazz)) {
            _loadedMethods.put(clazz, new HashMap());
        }
        if (!(loadedMethodNames = _loadedMethods.get(clazz)).containsKey(name)) {
            loadedMethodNames.put(name, new HashMap());
        }
        if ((loadedSignatures = loadedMethodNames.get(name)).containsKey(wrappedArg = new ArrayWrapper(args))) {
            return loadedSignatures.get(wrappedArg);
        }
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name) && Arrays.equals(args, m.getParameterTypes())) {
                m.setAccessible(true);
                loadedSignatures.put(wrappedArg, m);
                return m;
            }
            ++n2;
        }
        loadedSignatures.put(wrappedArg, null);
        return null;
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object connection = handle.getClass().getField("playerConnection").get(handle);
            connection.getClass().getMethod("sendPacket", Reflection.getNMSClass("Packet")).invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

