/*
 * Decompiled with CFR 0.152.
 */
package me.kieranlington.Utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private final String FILENAME;
    private final Plugin PLUGIN;
    private final File FOLDER;
    private FileConfiguration config;
    private File configFile;

    public Config(String filename, Plugin inst) {
        if (!filename.endsWith(".yml")) {
            filename = String.valueOf(filename) + ".yml";
        }
        this.FILENAME = filename;
        this.PLUGIN = inst;
        this.FOLDER = this.PLUGIN.getDataFolder();
        this.config = null;
        this.configFile = null;
        this.copyFromResources();
        this.reloadConfig();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    private void copyFromResources() {
        try {
            YamlConfiguration cf = YamlConfiguration.loadConfiguration((InputStream)this.PLUGIN.getResource(this.FILENAME));
            for (String path : cf.getKeys(true)) {
                if (this.getConfig().isSet(path)) continue;
                this.getConfig().set(path, cf.get(path));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveConfig();
    }

    public void reloadConfig() {
        this.config = null;
        this.configFile = null;
        if (!this.FOLDER.exists()) {
            try {
                if (this.FOLDER.mkdir()) {
                    this.PLUGIN.getLogger().log(Level.INFO, "Folder " + this.FOLDER.getName() + " created.");
                } else {
                    this.PLUGIN.getLogger().log(Level.WARNING, "Unable to create folder " + this.FOLDER.getName() + ".");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.configFile = new File(this.FOLDER, this.FILENAME);
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                try {
                    YamlConfiguration cf = YamlConfiguration.loadConfiguration((InputStream)this.PLUGIN.getResource(this.FILENAME));
                    for (String path : cf.getKeys(true)) {
                        if (this.getConfig().isSet(path)) continue;
                        this.getConfig().set(path, cf.get(path));
                    }
                    this.saveConfig();
                }
                catch (Exception exception) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void saveConfig() {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.PLUGIN.getLogger().log(Level.WARNING, "Could not save config to " + this.configFile.getName(), ex);
        }
    }

    public void set(String path, Object o) {
        this.getConfig().set(path, o);
    }

    public void setLocation(String path, Location l) {
        if (l == null) {
            this.getConfig().set(path, null);
        } else {
            this.getConfig().set(String.valueOf(path) + ".w", (Object)l.getWorld().getName());
            this.getConfig().set(String.valueOf(path) + ".x", (Object)l.getX());
            this.getConfig().set(String.valueOf(path) + ".y", (Object)l.getY());
            this.getConfig().set(String.valueOf(path) + ".z", (Object)l.getZ());
            this.getConfig().set(String.valueOf(path) + ".yaw", (Object)Float.valueOf(l.getYaw()));
            this.getConfig().set(String.valueOf(path) + ".pitch", (Object)Float.valueOf(l.getPitch()));
        }
    }

    public Location getLocation(String path) {
        try {
            Location l = new Location(Bukkit.getWorld((String)this.getConfig().getString(String.valueOf(path) + ".w")), this.getConfig().getDouble(String.valueOf(path) + ".x"), this.getConfig().getDouble(String.valueOf(path) + ".y"), this.getConfig().getDouble(String.valueOf(path) + ".z"), Float.parseFloat("" + this.getConfig().getDouble(String.valueOf(path) + ".yaw")), Float.parseFloat("" + this.getConfig().getDouble(String.valueOf(path) + ".pitch")));
            return l;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getColoured(String path) {
        String raw = this.getString(path);
        if (raw == null || path == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
    }

    public String getMessage(String path) {
        return this.getColoured(path);
    }

    public UUID getUUID(String path) {
        return UUID.fromString(this.getConfig().getString(path));
    }

    public List<UUID> getUUIDlist(String path) {
        ArrayList<UUID> UUIDs = new ArrayList<UUID>();
        for (String uuid : this.getConfig().getStringList(path)) {
            UUIDs.add(UUID.fromString(uuid));
        }
        return UUIDs;
    }

    public void setUUID(String path, UUID uuid) {
        if (uuid == null) {
            this.getConfig().set(path, null);
        } else {
            this.getConfig().set(path, (Object)uuid.toString());
        }
    }

    public void setUUIDlist(String path, List<UUID> UUIDs) {
        if (UUIDs == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (UUID uuid : UUIDs) {
            list.add(uuid.toString());
        }
        this.getConfig().set(path, list);
    }

    public boolean getBoolean(String path) {
        if (path == null) {
            return false;
        }
        return this.getConfig().isSet(path) ? this.getConfig().getBoolean(path) : false;
    }

    public float getFloat(String path) {
        return this.getConfig().isSet(path) ? Float.valueOf(this.getConfig().getString(path)).floatValue() : 0.0f;
    }

    public double getDouble(String path) {
        return this.getConfig().isSet(path) ? Double.valueOf(this.getConfig().getString(path)) : null;
    }

    public short getShort(String path) {
        return this.getConfig().isSet(path) ? Short.valueOf(this.getConfig().getString(path)) : null;
    }

    public int getInt(String path) {
        if (path == null) {
            return 0;
        }
        return this.getConfig().isSet(path) ? Integer.valueOf(this.getConfig().getString(path)) : 0;
    }

    public String getString(String path) {
        return this.getConfig().isSet(path) ? this.getConfig().getString(path) : null;
    }

    public Sound getSound(String path) {
        return this.getConfig().isSet(path) ? Sound.valueOf((String)this.getConfig().getString(path)) : null;
    }

    public List<String> getStringList(String path) {
        return this.getConfig().getStringList(path);
    }

    public List<Integer> getIntegerList(String path) {
        return this.getConfig().getIntegerList(path);
    }

    public Long getLong(String path) {
        return this.getConfig().getLong(path);
    }

    public ChatColor getChatColor(String path) {
        return ChatColor.valueOf((String)this.getConfig().getString(path));
    }

    public List<Sound> getSoundList(String path) {
        ArrayList<Sound> sounds = new ArrayList<Sound>();
        for (String sound : this.getConfig().getStringList(path)) {
            try {
                Sound s = Sound.valueOf((String)sound);
                sounds.add(s);
            }
            catch (IllegalArgumentException e) {
                Bukkit.getLogger().warning("[KOTR] Unknown sound - \"" + sound + "\"");
            }
        }
        return sounds;
    }
}

