/*
 * Decompiled with CFR 0.152.
 */
package me.kieranlington.KingOfTheRealm.listeners.addons;

import java.util.UUID;
import me.kieranlington.KingOfTheRealm.KOTR;
import me.kieranlington.KingOfTheRealm.expansions.EXPansion.EXPansion;
import me.kieranlington.KingOfTheRealm.expansions.EXPansion.EXPansionMessageType;
import me.kieranlington.KingOfTheRealm.listeners.addons.CustomListener;
import me.kieranlington.KingOfTheRealm.realm.Realm;
import me.kieranlington.KingOfTheRealm.realm.RealmHandler;
import me.kieranlington.KingOfTheRealm.utils.messages.MessageOptions;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerExpChangeEvent;

public class EXPListener
extends CustomListener {
    private EXPansion instance;

    public EXPListener(EXPansion plugin, KOTR instance) {
        super(null, instance);
        this.instance = plugin;
    }

    @EventHandler
    private void onEXPChange(PlayerExpChangeEvent e) {
        int amount = e.getAmount();
        Player p = e.getPlayer();
        this.addTo(p, amount);
        Realm realm = RealmHandler.getRealmFromForcedPermissionNode((Player)p);
        if (realm == null) {
            realm = RealmHandler.getRealmFromPlayer((Player)p);
        }
        if (realm != null && realm.thereIsTax() && !realm.isAssociated(p)) {
            int tax = realm.getTax();
            float taxFloat = (float)tax / 100.0f;
            int required = 100 / tax;
            int experience = this.instance.expCounter.get(p);
            if (experience >= required) {
                this.reset(p);
                int deduction = Math.round((float)amount * taxFloat);
                int leftOver = amount - deduction;
                e.setAmount(leftOver);
                Player ruler = Bukkit.getPlayer((UUID)realm.getRuler());
                MessageOptions options = new MessageOptions().target(p).realm(realm).exp(deduction);
                this.instance.sendMessage(EXPansionMessageType.EXPANSION_EXP_PAY_TAX, (CommandSender)p, options);
                if (ruler.isOnline()) {
                    ruler.getPlayer().giveExp(deduction);
                    this.instance.sendMessage(EXPansionMessageType.EXPANSION_EXP_RECEIVE_TAX, (CommandSender)ruler.getPlayer(), options);
                }
            }
        }
    }

    private void addTo(Player player, int amount) {
        int newAmount = this.instance.expCounter.get(player) + amount;
        this.instance.expCounter.remove(player);
        this.instance.expCounter.put(player, newAmount);
    }

    private void reset(Player player) {
        this.instance.expCounter.remove(player);
        this.instance.expCounter.put(player, 0);
    }
}

