/*
 * Decompiled with CFR 0.152.
 */
package me.kieranlington.KingOfTheRealm.expansions.EXPansion;

import java.util.Collection;
import java.util.HashMap;
import me.kieranlington.KingOfTheRealm.KOTR;
import me.kieranlington.KingOfTheRealm.expansions.EXPansion.EXPansionMessageType;
import me.kieranlington.KingOfTheRealm.listeners.addons.EXPListener;
import me.kieranlington.KingOfTheRealm.realm.RealmHandler;
import me.kieranlington.KingOfTheRealm.utils.messages.MessageOptions;
import me.kieranlington.KingOfTheRealm.utils.messages.MessagePlaceholders;
import me.kieranlington.KingOfTheRealm.utils.messages.MessageType;
import me.kieranlington.Utils.ActionBar;
import me.kieranlington.Utils.Config;
import me.kieranlington.Utils.Title;
import me.kieranlington.Utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EXPansion
extends JavaPlugin
implements Listener {
    KOTR kotr;
    Config messages = new Config("messages.yml", (Plugin)this);
    public HashMap<Player, Integer> expCounter = new HashMap();
    private ActionBar actionBar = new ActionBar();
    private Title title = new Title();

    public void onEnable() {
        if (Bukkit.getPluginManager().isPluginEnabled("KOTR")) {
            this.kotr = (KOTR)Bukkit.getPluginManager().getPlugin("KOTR");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EXPListener(this, this.kotr), (Plugin)this);
        Utils.getOnlinePlayers().forEach(p -> {
            Integer n = this.expCounter.put((Player)p, 0);
        });
    }

    public void onDisable() {
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        this.expCounter.put(player, 0);
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.expCounter.remove(player);
    }

    public void sendMessage(EXPansionMessageType type, CommandSender recipient) {
        MessageOptions options = new MessageOptions();
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            options = options.realm(RealmHandler.getRealmFromPlayer((Player)player)).target(player);
        }
        this.sendMessage(type, recipient, options);
    }

    public void sendMessage(EXPansionMessageType expansionExpReceiveTax, CommandSender recipient, MessageOptions messageOptions) {
        String message = this.messages.getMessage(String.valueOf(expansionExpReceiveTax.toString()) + ".text");
        message = MessagePlaceholders.parseSpecialMessage((String)message, (CommandSender)recipient, (MessageOptions)messageOptions);
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            if (this.messages.getBoolean(String.valueOf(expansionExpReceiveTax.toString()) + ".actionbar")) {
                this.actionBar.send(player, message);
            }
            if (this.messages.getBoolean(String.valueOf(expansionExpReceiveTax.toString()) + ".title")) {
                String subtext = this.messages.getMessage(String.valueOf(expansionExpReceiveTax.toString()) + ".subtext");
                subtext = MessagePlaceholders.parseSpecialMessage((String)subtext, (CommandSender)recipient, (MessageOptions)messageOptions);
                this.title.send(player, message, subtext, KOTR.getOptions().misc.titleStay, true);
            }
        }
        if (this.messages.getBoolean(String.valueOf(expansionExpReceiveTax.toString()) + ".chat")) {
            recipient.sendMessage(message);
        }
    }

    public void sendMessage(MessageType type, Collection<? extends CommandSender> recipients, MessageOptions messageOptions) {
        String message = this.messages.getMessage(String.valueOf(type.toString()) + ".text");
        String subtext = this.messages.getMessage(String.valueOf(type.toString()) + ".subtext");
        int stayTime = KOTR.getOptions().misc.titleStay;
        for (CommandSender commandSender : recipients) {
            String tempMsg = MessagePlaceholders.parseSpecialMessage((String)message, (CommandSender)commandSender, (MessageOptions)messageOptions);
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                if (this.messages.getBoolean(String.valueOf(type.toString()) + ".actionbar")) {
                    this.actionBar.send(player, message);
                }
                if (this.messages.getBoolean(String.valueOf(type.toString()) + ".title")) {
                    String tempSub = MessagePlaceholders.parseSpecialMessage((String)subtext, (CommandSender)commandSender, (MessageOptions)messageOptions);
                    this.title.send(player, tempMsg, tempSub, stayTime, true);
                }
            }
            if (!this.messages.getBoolean(String.valueOf(type.toString()) + ".chat")) continue;
            commandSender.sendMessage(tempMsg);
        }
    }

    public void broadcastMessage(MessageType type) {
        this.broadcastMessage(type, new MessageOptions());
    }

    public void broadcastMessage(MessageType type, MessageOptions messageOptions) {
        String message = this.messages.getMessage(String.valueOf(type.toString()) + ".text");
        message = MessagePlaceholders.parseSpecialMessage((String)message, (CommandSender)Bukkit.getConsoleSender(), (MessageOptions)messageOptions);
        String subtext = this.messages.getMessage(String.valueOf(type.toString()) + ".subtext");
        subtext = MessagePlaceholders.parseSpecialMessage((String)subtext, (CommandSender)Bukkit.getConsoleSender(), (MessageOptions)messageOptions);
        int stayTime = KOTR.getOptions().misc.titleStay;
        boolean actionbarEnabled = this.messages.getBoolean(String.valueOf(type.toString()) + ".actionbar");
        boolean titleEnabled = this.messages.getBoolean(String.valueOf(type.toString()) + ".title");
        boolean chatEnabled = this.messages.getBoolean(String.valueOf(type.toString()) + ".chat");
        for (Player player : Utils.getOnlinePlayers()) {
            if (actionbarEnabled) {
                this.actionBar.send(player, message);
            }
            if (chatEnabled) {
                player.sendMessage(message);
            }
            if (!titleEnabled) continue;
            this.title.send(player, message, subtext, stayTime, true);
        }
        Bukkit.getConsoleSender().sendMessage(message);
    }
}

