/*
 * Decompiled with CFR 0.152.
 */
package com.github.zathrus_writer.commandsex.helpers;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.Language;
import com.github.zathrus_writer.commandsex.handlers.Handler_condensejoins;
import com.github.zathrus_writer.commandsex.helpers.LogHelper;
import com.github.zathrus_writer.commandsex.helpers.Nicknames;
import com.github.zathrus_writer.commandsex.helpers.Utils;
import com.github.zathrus_writer.commandsex.helpers.scripting.CommanderCommandSender;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;

public class XMPPer
implements Listener,
PacketListener,
SubjectUpdatedListener,
UserStatusListener,
ParticipantStatusListener {
    public static String chatPrefix = "";
    public static Connection xmppConnection;
    public static MultiUserChat chatRoom;
    public static Map<String, String> participantNicks;
    public static String cmdPrefix;
    public static final CommanderCommandSender ccs;
    public static Integer lastMessageStamp;

    public XMPPer() {
        FileConfiguration cnf = CommandsEX.getConf();
        if (cnf.getBoolean("xmppEnabled")) {
            LogHelper.logInfo("[CommandsEX] " + Language._("xmppConnecting", ""));
            cmdPrefix = cnf.getString("xmppCommandPrefix", "#");
            participantNicks = new HashMap<String, String>();
            xmppConnection = new XMPPConnection(cnf.getString("xmppHost", "localhost"));
            try {
                xmppConnection.connect();
                if (cnf.getString("xmppUser", "").equals("")) {
                    LogHelper.logInfo(Language._("xmppAnonymousLogin", ""));
                    xmppConnection.loginAnonymously();
                } else {
                    xmppConnection.login(cnf.getString("xmppUser"), cnf.getString("xmppPassword", ""));
                }
                DiscussionHistory history = new DiscussionHistory();
                history.setMaxStanzas(0);
                chatRoom = new MultiUserChat(xmppConnection, cnf.getString("xmppRoom.name"));
                chatRoom.addMessageListener((PacketListener)this);
                chatRoom.addParticipantStatusListener((ParticipantStatusListener)this);
                chatRoom.addSubjectUpdatedListener((SubjectUpdatedListener)this);
                chatRoom.addUserStatusListener((UserStatusListener)this);
                try {
                    chatRoom.join(cnf.getString("xmppBotNick", "CommandsEX"), cnf.getString("xmppRoom.password", ""), history, (long)SmackConfiguration.getPacketReplyTimeout());
                    for (Occupant occupant : chatRoom.getParticipants()) {
                        participantNicks.put(occupant.getJid(), occupant.getNick());
                    }
                }
                catch (XMPPException e) {
                    LogHelper.logSevere("[CommandsEX] " + Language._("xmppUnableToJoinRoom", ""));
                    LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                    return;
                }
            }
            catch (XMPPException e) {
                LogHelper.logSevere("[CommandsEX] " + Language._("xmppConnectionFailed", ""));
                LogHelper.logDebug("Message: " + e.getMessage() + ", cause: " + e.getCause());
                return;
            }
            if (CommandsEX.getConf().getBoolean("xmppEnablePing", true)) {
                Integer pingTime = CommandsEX.getConf().getInt("xmppEnablePingTime", 45);
                Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)CommandsEX.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (Utils.getUnixTimestamp(0L) - lastMessageStamp > 300) {
                            try {
                                chatRoom.sendMessage(XMPPer.filterOutgoing("(ping)"));
                                lastMessageStamp = Utils.getUnixTimestamp(0L);
                            }
                            catch (XMPPException ex) {
                                LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
                            }
                        }
                    }
                }, (long)(1200 * pingTime), (long)(1200 * pingTime));
            }
            CommandsEX.onDisableFunctions.add("com.github.zathrus_writer.commandsex.handlers.Handler_xmpp#####onDisable");
            CommandsEX.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)CommandsEX.plugin);
        }
    }

    public static void onDisable(CommandsEX p) {
        if (xmppConnection.isConnected()) {
            xmppConnection.disconnect();
        }
        xmppConnection = null;
    }

    public static String filterOutgoing(String input) {
        StringBuilder in = new StringBuilder(input);
        while (in.indexOf("\u00a7") != -1) {
            in.replace(in.indexOf("\u00a7"), in.indexOf("\u00a7") + 2, "");
        }
        return in.toString();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void sendJoinMessage(PlayerJoinEvent e) {
        try {
            chatRoom.sendMessage(XMPPer.filterOutgoing(e.getJoinMessage()));
            lastMessageStamp = Utils.getUnixTimestamp(0L);
        }
        catch (XMPPException ex) {
            LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void interceptChat(final AsyncPlayerChatEvent e) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CommandsEX.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    chatRoom.sendMessage(XMPPer.filterOutgoing(String.format(e.getFormat(), Nicknames.getNick(e.getPlayer().getName()), e.getMessage())));
                    lastMessageStamp = Utils.getUnixTimestamp(0L);
                }
                catch (XMPPException ex) {
                    LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void sendPrivate(PlayerCommandPreprocessEvent e) {
        String cmd = e.getMessage();
        String[] s = cmd.split(" ");
        if (s.length >= 3) {
            String sName = Nicknames.getNick(e.getPlayer().getName());
            if (CommandsEX.getConf().getList("privateMsgCommands").contains(s[0].substring(1)) && s.length >= 3) {
                try {
                    if (Bukkit.getPlayer((String)s[1]) != null) {
                        chatRoom.sendMessage(XMPPer.filterOutgoing("(" + sName + " -> " + s[1] + "): " + e.getMessage().replace(s[0] + " " + s[1], "")));
                    }
                }
                catch (XMPPException ex) {
                    LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void sendLeaveMessage(PlayerQuitEvent e) {
        try {
            chatRoom.sendMessage(XMPPer.filterOutgoing(e.getQuitMessage()));
            lastMessageStamp = Utils.getUnixTimestamp(0L);
        }
        catch (XMPPException ex) {
            LogHelper.logDebug("Message: " + ex.getMessage() + ", cause: " + ex.getCause());
        }
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            if (!chatRoom.getOccupant(packet.getFrom()).getNick().equals(chatRoom.getNickname())) {
                Message message = (Message)packet;
                if (message.getBody().startsWith(cmdPrefix)) {
                    if (CommandsEX.getConf().getList("xmppAdmins").contains(chatRoom.getOccupant(message.getFrom()).getNick())) {
                        String cmd = message.getBody().substring(cmdPrefix.length());
                        CommandsEX.plugin.getServer().dispatchCommand((CommandSender)ccs, cmd);
                    }
                } else {
                    Occupant actor = chatRoom.getOccupant(message.getFrom());
                    String actorNick = (actor.getRole().equals("moderator") ? "@" : (actor.getRole().equals("participant") ? "+" : "")) + actor.getNick();
                    String body = message.getBody();
                    CommandsEX.plugin.getServer().broadcastMessage(chatPrefix + actorNick + ": " + body);
                }
            }
        } else {
            LogHelper.logWarning(Language._("xmppUnknownPacket", "") + packet.getClass().toString());
        }
    }

    public void kicked(String actor, String reason) {
    }

    public void voiceGranted() {
    }

    public void voiceRevoked() {
    }

    public void banned(String actor, String reason) {
    }

    public void membershipGranted() {
    }

    public void membershipRevoked() {
    }

    public void moderatorGranted() {
    }

    public void moderatorRevoked() {
    }

    public void ownershipGranted() {
    }

    public void ownershipRevoked() {
    }

    public void adminGranted() {
    }

    public void adminRevoked() {
    }

    public void subjectUpdated(String subject, String from) {
    }

    public void joined(String participant) {
        block4: {
            Occupant actor = chatRoom.getOccupant(participant);
            String joiner = chatPrefix + actor.getNick();
            try {
                if (CommandsEX.getConf().getBoolean("xmppNotifyChatJoin", true)) {
                    Handler_condensejoins.joins.add("#" + joiner);
                }
                participantNicks.put(participant, actor.getNick());
            }
            catch (Throwable e) {
                if (participantNicks.containsKey(participant)) break block4;
                if (CommandsEX.getConf().getBoolean("xmppNotifyChatJoin", true)) {
                    CommandsEX.plugin.getServer().broadcastMessage(joiner + " " + Language._("xmppJoin", ""));
                }
                participantNicks.put(participant, actor.getNick());
            }
        }
    }

    public void left(String participant) {
        String actorNick = chatPrefix + participantNicks.get(participant);
        try {
            if (CommandsEX.getConf().getBoolean("xmppNotifyChatJoin", true)) {
                Handler_condensejoins.leaves.add("#" + actorNick);
            }
            participantNicks.remove(participant);
        }
        catch (Throwable e) {
            if (CommandsEX.getConf().getBoolean("xmppNotifyChatJoin", true)) {
                CommandsEX.plugin.getServer().broadcastMessage(actorNick + " " + Language._("xmppLeave", ""));
            }
            participantNicks.remove(participant);
        }
    }

    public void kicked(String participant, String actor, String reason) {
    }

    public void voiceGranted(String participant) {
    }

    public void voiceRevoked(String participant) {
    }

    public void banned(String participant, String actor, String reason) {
    }

    public void membershipGranted(String participant) {
    }

    public void membershipRevoked(String participant) {
    }

    public void moderatorGranted(String participant) {
    }

    public void moderatorRevoked(String participant) {
    }

    public void ownershipGranted(String participant) {
    }

    public void ownershipRevoked(String participant) {
    }

    public void adminGranted(String participant) {
    }

    public void adminRevoked(String participant) {
    }

    public void nicknameChanged(String participant, String newNickname) {
        String message = participantNicks.get(participant) + " " + Language._("xmppNameChange", "") + newNickname;
        if (CommandsEX.getConf().getBoolean("xmppNotifyChatJoin", true)) {
            CommandsEX.plugin.getServer().broadcastMessage(chatPrefix + message);
        }
        participantNicks.put(participant, newNickname);
    }

    static {
        ccs = new CommanderCommandSender();
        lastMessageStamp = Utils.getUnixTimestamp(0L);
    }
}

